/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.client.world.cloned.PalettedContainerAccessor;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalette;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPaletteFallback;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalleteArray;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class ClonedChunkSection {
    private static final LightLayer[] LIGHT_TYPES = LightLayer.values();
    private static final LevelChunkSection EMPTY_SECTION = new LevelChunkSection(0, BuiltinRegistries.f_123865_);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final ClonedChunkSectionCache backingCache;
    private final Short2ObjectMap<BlockEntity> blockEntities;
    private final Short2ObjectMap<Object> renderAttachments;
    private final DataLayer[] lightDataArrays;
    private SectionPos pos;
    private SimpleBitStorage blockStateData;
    private ClonedPalette<BlockState> blockStatePalette;
    private PalettedContainerRO<Holder<Biome>> biomeData;
    private long lastUsedTimestamp;

    ClonedChunkSection(ClonedChunkSectionCache backingCache) {
        this.backingCache = backingCache;
        this.blockEntities = new Short2ObjectOpenHashMap();
        this.renderAttachments = new Short2ObjectOpenHashMap();
        this.lightDataArrays = new DataLayer[LIGHT_TYPES.length];
    }

    public void init(Level world, SectionPos pos) {
        LevelChunk chunk = world.m_6325_(pos.m_123341_(), pos.m_123343_());
        if (chunk == null) {
            throw new RuntimeException("Couldn't retrieve chunk at " + pos.m_123251_());
        }
        LevelChunkSection section = ClonedChunkSection.getChunkSection(world, (ChunkAccess)chunk, pos);
        if (section == null) {
            section = EMPTY_SECTION;
        }
        this.reset(pos);
        this.copyBlockData(section);
        this.copyLightData(world);
        this.copyBiomeData(section);
        this.copyBlockEntities(chunk, pos);
    }

    private void reset(SectionPos pos) {
        this.pos = pos;
        this.blockEntities.clear();
        this.renderAttachments.clear();
        this.blockStateData = null;
        this.blockStatePalette = null;
        this.biomeData = null;
        Arrays.fill(this.lightDataArrays, null);
    }

    private void copyBlockData(LevelChunkSection section) {
        PalettedContainer.Data container = PalettedContainerAccessor.getData(section.m_63019_());
        this.blockStateData = ClonedChunkSection.copyBlockData(container);
        this.blockStatePalette = ClonedChunkSection.copyPalette(container);
    }

    private void copyLightData(Level world) {
        for (LightLayer type : LIGHT_TYPES) {
            this.lightDataArrays[type.ordinal()] = world.m_5518_().m_75814_(type).m_8079_(this.pos);
        }
    }

    private void copyBiomeData(LevelChunkSection section) {
        this.biomeData = section.m_187996_();
    }

    public int getLightLevel(LightLayer type, int x, int y, int z) {
        DataLayer array = this.lightDataArrays[type.ordinal()];
        if (array != null) {
            return array.m_62560_(x, y, z);
        }
        return 0;
    }

    private void copyBlockEntities(LevelChunk chunk, SectionPos chunkCoord) {
        BoundingBox box = new BoundingBox(chunkCoord.m_123229_(), chunkCoord.m_123234_(), chunkCoord.m_123239_(), chunkCoord.m_123244_(), chunkCoord.m_123247_(), chunkCoord.m_123248_());
        for (Map.Entry entry : chunk.m_62954_().entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            BlockEntity entity = (BlockEntity)entry.getValue();
            if (!box.m_71051_((Vec3i)pos)) continue;
            this.blockEntities.put(SectionPos.m_123218_((BlockPos)pos), (Object)entity);
        }
    }

    public Holder<Biome> getBiome(int x, int y, int z) {
        return (Holder)this.biomeData.m_63087_(x, y, z);
    }

    public BlockEntity getBlockEntity(int x, int y, int z) {
        return (BlockEntity)this.blockEntities.get(ClonedChunkSection.packLocal(x, y, z));
    }

    public Object getBlockEntityRenderAttachment(int x, int y, int z) {
        return this.renderAttachments.get(ClonedChunkSection.packLocal(x, y, z));
    }

    public SimpleBitStorage getBlockData() {
        return this.blockStateData;
    }

    public ClonedPalette<BlockState> getBlockPalette() {
        return this.blockStatePalette;
    }

    public SectionPos getPosition() {
        return this.pos;
    }

    private static ClonedPalette<BlockState> copyPalette(PalettedContainer.Data<BlockState> container) {
        Palette palette = container.f_188102_();
        if (palette instanceof GlobalPalette) {
            return new ClonedPaletteFallback<BlockState>(Block.f_49791_);
        }
        BlockState[] array = new BlockState[container.f_188102_().m_62680_()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (BlockState)palette.m_5795_(i);
        }
        return new ClonedPalleteArray<BlockState>(array);
    }

    private static SimpleBitStorage copyBlockData(PalettedContainer.Data<BlockState> container) {
        BitStorage storage = container.f_188101_();
        long[] data = storage.m_13513_();
        int bits = container.f_188100_().f_188086_();
        if (bits == 0) {
            return new SimpleBitStorage(1, storage.m_13521_());
        }
        return new SimpleBitStorage(bits, storage.m_13521_(), (long[])data.clone());
    }

    private static LevelChunkSection getChunkSection(Level world, ChunkAccess chunk, SectionPos pos) {
        LevelChunkSection section = null;
        if (!world.m_151562_(SectionPos.m_123223_((int)pos.m_123342_()))) {
            section = chunk.m_7103_()[world.m_151566_(pos.m_123342_())];
        }
        return section;
    }

    public void acquireReference() {
        this.referenceCount.incrementAndGet();
    }

    public boolean releaseReference() {
        return this.referenceCount.decrementAndGet() <= 0;
    }

    public ClonedChunkSectionCache getBackingCache() {
        return this.backingCache;
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }

    private static short packLocal(int x, int y, int z) {
        return (short)(x << 8 | z << 4 | y);
    }
}

