/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.compat.ccl.SinkingVertexBuilder;
import me.jellysquid.mods.sodium.client.compat.forge.ForgeBlockRenderer;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.embeddedt.embeddium.api.BlockRendererRegistry;

public class BlockRenderer {
    private static final PoseStack EMPTY_STACK = new PoseStack();
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final ColorBlender colorBlender;
    private final ForgeBlockRenderer forgeBlockRenderer = new ForgeBlockRenderer();
    private final LightPipelineProvider lighters;
    private final boolean useAmbientOcclusion;
    private boolean useReorienting;
    private final List<BlockRendererRegistry.Renderer> customRenderers = new ObjectArrayList();

    public BlockRenderer(Minecraft client, LightPipelineProvider lighters, ColorBlender colorBlender) {
        this.blockColors = (BlockColorsExtended)client.m_91298_();
        this.colorBlender = colorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.m_91086_();
    }

    public boolean renderModel(BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, BakedModel model, ChunkModelBuilder buffers, boolean cull, long seed, ModelData modelData, RenderType layer, RandomSource random) {
        LightMode mode = this.getLightingMode(state, model, world, pos, layer);
        LightPipeline lighter = this.lighters.getLighter(mode);
        Vec3 offset = state.m_60824_((BlockGetter)world, pos);
        boolean rendered = false;
        this.customRenderers.clear();
        BlockRendererRegistry.instance().fillCustomRenderers(this.customRenderers, state, pos, world, layer);
        if (!this.customRenderers.isEmpty()) {
            SinkingVertexBuilder builder = SinkingVertexBuilder.getInstance();
            for (BlockRendererRegistry.Renderer customRenderer : this.customRenderers) {
                builder.reset();
                BlockRendererRegistry.RenderResult result = customRenderer.renderBlock(state, pos, world, builder, random, modelData, layer);
                builder.flush(buffers, origin);
                if (result != BlockRendererRegistry.RenderResult.OVERRIDE) continue;
                return true;
            }
        }
        if (ForgeBlockRenderer.useForgeLightingPipeline()) {
            PoseStack mStack;
            if (offset != Vec3.f_82478_) {
                mStack = new PoseStack();
                mStack.m_85836_();
                mStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            } else {
                mStack = EMPTY_STACK;
            }
            SinkingVertexBuilder builder = SinkingVertexBuilder.getInstance();
            builder.reset();
            rendered = this.forgeBlockRenderer.renderBlock(mode, state, pos, world, model, mStack, builder, random, seed, modelData, cull, this.occlusionCache, buffers, layer);
            builder.flush(buffers, origin);
            return rendered;
        }
        for (PoseStack dir : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(seed);
            List sided = model.getQuads(state, (Direction)dir, random, modelData, layer);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (BlockGetter)world, pos, (Direction)dir)) continue;
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, sided, (Direction)dir);
            rendered = true;
        }
        random.m_188584_(seed);
        List all = model.getQuads(state, null, random, modelData, layer);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, all, null);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadList(BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, LightPipeline lighter, Vec3 offset, ChunkModelBuilder buffers, List<BakedQuad> quads, Direction cullFace) {
        int i;
        ModelQuadFacing facing = cullFace == null ? ModelQuadFacing.UNASSIGNED : ModelQuadFacing.fromDirection(cullFace);
        ColorSampler<BlockState> colorizer = null;
        ModelVertexSink vertices = buffers.getVertexSink();
        vertices.ensureCapacity(quads.size() * 4);
        IndexBufferBuilder indices = buffers.getIndexBufferBuilder(facing);
        this.useReorienting = true;
        int quadsSize = quads.size();
        for (i = 0; i < quadsSize; ++i) {
            if (quads.get(i).hasAmbientOcclusion()) continue;
            this.useReorienting = false;
            break;
        }
        quadsSize = quads.size();
        for (i = 0; i < quadsSize; ++i) {
            BakedQuad quad = quads.get(i);
            LightPipeline quadLighter = !quad.hasAmbientOcclusion() ? this.lighters.getLighter(LightMode.FLAT) : lighter;
            QuadLightData light = this.cachedQuadLightData;
            quadLighter.calculate((ModelQuadView)quad, pos, light, cullFace, quad.m_111306_(), quad.m_111307_());
            if (quad.m_111304_() && colorizer == null) {
                colorizer = this.blockColors.getColorProvider(state);
            }
            this.renderQuad(world, state, pos, origin, vertices, indices, offset, colorizer, quad, light, buffers);
        }
        vertices.flush();
    }

    private void renderQuad(BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, ModelVertexSink vertices, IndexBufferBuilder indices, Vec3 blockOffset, ColorSampler<BlockState> colorSampler, BakedQuad bakedQuad, QuadLightData light, ChunkModelBuilder model) {
        ModelQuadView src = (ModelQuadView)bakedQuad;
        ModelQuadOrientation orientation = this.useReorienting ? ModelQuadOrientation.orientByBrightness(light.br) : ModelQuadOrientation.NORMAL;
        int[] colors = null;
        if (bakedQuad.m_111304_()) {
            colors = this.colorBlender.getColors(world, pos, src, colorSampler, state);
        }
        int vertexStart = vertices.getVertexCount();
        for (int i = 0; i < 4; ++i) {
            int j = orientation.getVertexIndex(i);
            float x = src.getX(j) + (float)blockOffset.m_7096_();
            float y = src.getY(j) + (float)blockOffset.m_7098_();
            float z = src.getZ(j) + (float)blockOffset.m_7094_();
            int color = ColorABGR.mul(colors != null ? colors[j] : src.getColor(j), light.br[j]);
            float u = src.getTexU(j);
            float v = src.getTexV(j);
            int lm = ModelQuadUtil.mergeBakedLight(src.getLight(j), light.lm[j]);
            vertices.writeVertex((Vec3i)origin, x, y, z, color, u, v, lm, model.getChunkId());
        }
        indices.add(vertexStart, ModelQuadWinding.CLOCKWISE);
        TextureAtlasSprite sprite = src.getSprite();
        if (sprite != null) {
            model.addSprite(sprite);
        }
    }

    @Deprecated
    private LightMode getLightingMode(BlockState state, BakedModel model, BlockAndTintGetter world, BlockPos pos) {
        return this.getLightingMode(state, model, world, pos, RenderType.m_110451_());
    }

    private LightMode getLightingMode(BlockState state, BakedModel model, BlockAndTintGetter world, BlockPos pos, RenderType layer) {
        if (this.useAmbientOcclusion && model.useAmbientOcclusion(state, layer) && state.getLightEmission((BlockGetter)world, pos) == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

