package me.jellysquid.mods.sodium.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.render.*;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import java.util.function.Consumer;

public abstract class AbstractWidget implements Widget, GuiEventListener, NarratableEntry {
    protected final Font font;

    protected AbstractWidget() {
        this.font = Minecraft.m_91087_().f_91062_;
    }

    protected void drawString(PoseStack matrixStack, String str, int x, int y, int color) {
        this.font.m_92883_(matrixStack, str, x, y, color);
    }

    protected void drawString(PoseStack matrixStack, Component text, int x, int y, int color) {
        this.font.m_92889_(matrixStack, text, x, y, color);
    }

    protected void drawRect(double x1, double y1, double x2, double y2, int color) {
        float a = (float) (color >> 24 & 255) / 255.0F;
        float r = (float) (color >> 16 & 255) / 255.0F;
        float g = (float) (color >> 8 & 255) / 255.0F;
        float b = (float) (color & 255) / 255.0F;

        this.drawQuads(vertices -> addQuad(vertices, x1, y1, x2, y2, a, r, g, b));
    }

    protected void drawQuads(Consumer<VertexConsumer> consumer) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);

        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();

        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);

        consumer.accept(bufferBuilder);

        BufferBuilder.RenderedBuffer output = bufferBuilder.m_231175_();

        BufferUploader.m_231202_(output);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    protected static void addQuad(VertexConsumer consumer, double x1, double y1, double x2, double y2, float a, float r, float g, float b) {
        consumer.m_5483_(x2, y1, 0.0D).m_85950_(r, g, b, a).m_5752_();
        consumer.m_5483_(x1, y1, 0.0D).m_85950_(r, g, b, a).m_5752_();
        consumer.m_5483_(x1, y2, 0.0D).m_85950_(r, g, b, a).m_5752_();
        consumer.m_5483_(x2, y2, 0.0D).m_85950_(r, g, b, a).m_5752_();
    }

    protected void playClickSound() {
        Minecraft.m_91087_().m_91106_()
                .m_120367_(SimpleSoundInstance.m_119752_(SoundEvents.f_12490_, 1.0F));
    }

    protected int getStringWidth(String text) {
        return this.font.m_92895_(text);
    }

    protected int getStringWidth(FormattedText text) {
        return this.font.m_92852_(text);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        // FIXME
        return NarrationPriority.NONE;
    }

    public boolean method_37303() {
        // FIXME
        return true;
    }

    @Override
    public void m_142291_(NarrationElementOutput builder) {
        // FIXME
    }
}