package me.jellysquid.mods.sodium.mixin.features.texture_updates;

import com.mojang.blaze3d.platform.NativeImage;
import me.jellysquid.mods.sodium.client.util.color.ColorMixer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(TextureAtlasSprite.InterpolationData.class)
public class MixinSpriteInterpolated {
    @Shadow
    @Final
    private NativeImage[] images;

    @Unique
    private TextureAtlasSprite parent;

    private static final int STRIDE = 4;

    /**
     * @author IMS
     * @reason Replace fragile Shadow
     */
    @Inject(method = "<init>", at = @At("RETURN"))
    public void assignParent(TextureAtlasSprite parent, TextureAtlasSprite.Info info, int maxLevel, CallbackInfo ci) {
        this.parent = parent;
    }

    /**
     * @author JellySquid
     * @reason Drastic optimizations
     */
    @Overwrite
    void apply(TextureAtlasSprite.AnimatedTexture animation) {
        TextureAtlasSprite.FrameInfo animationFrame = animation.f_174750_.get(animation.f_174748_);

        int curIndex = animationFrame.f_174771_;
        int nextIndex = animation.f_174750_.get((animation.f_174748_ + 1) % animation.f_174750_.size()).f_174771_;

        if (curIndex == nextIndex) {
            return;
        }

        float delta = 1.0F - (float) animation.f_174749_ / (float) animationFrame.f_174772_;

        int f1 = ColorMixer.getStartRatio(delta);
        int f2 = ColorMixer.getEndRatio(delta);

        for (int layer = 0; layer < this.images.length; layer++) {
            int width = this.parent.f_174723_ >> layer;
            int height = this.parent.f_174724_ >> layer;

            int curX = ((curIndex % animation.f_174751_) * width);
            int curY = ((curIndex / animation.f_174751_) * height);

            int nextX = ((nextIndex % animation.f_174751_) * width);
            int nextY = ((nextIndex / animation.f_174751_) * height);

            NativeImage src = this.parent.f_118342_[layer];
            NativeImage dst = this.images[layer];

            // Destination pointers
            long dp = dst.f_84964_;

            for (int layerY = 0; layerY < height; layerY++) {
                // Source pointers
                long s1p = src.f_84964_ + (curX + ((long) (curY + layerY) * src.m_84982_())) * STRIDE;
                long s2p = src.f_84964_ + (nextX + ((long) (nextY + layerY) * src.m_84982_())) * STRIDE;

                for (int layerX = 0; layerX < width; layerX++) {
                    int colorA = MemoryUtil.memGetInt(s1p);
                    int colorB = MemoryUtil.memGetInt(s2p);
                    int colorMixed = ColorMixer.mixARGB(colorA, colorB, f1, f2) & 0x00FFFFFF;
                    // Use alpha from first color as-is, do not blend
                    MemoryUtil.memPutInt(dp, colorMixed | (colorA & 0xFF000000));

                    s1p += STRIDE;
                    s2p += STRIDE;
                    dp += STRIDE;
                }
            }
        }

        this.parent.m_118375_(0, 0, this.images);
    }

}
