/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import java.util.Collection;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.embeddedt.embeddium.api.ChunkDataBuiltEvent;

@Mod.EventBusSubscriber(modid="embeddium", value={Dist.CLIENT})
public class FlywheelCompat {
    private static final boolean flywheelLoaded = ModList.get().isLoaded("flywheel");

    public static boolean addAndFilterBEs(BlockEntity be) {
        if (flywheelLoaded) {
            if (Backend.canUseInstancing((Level)be.m_58904_())) {
                if (InstancedRenderRegistry.canInstance((BlockEntityType)be.m_58903_())) {
                    InstancedRenderDispatcher.getBlockEntities((LevelAccessor)be.m_58904_()).queueAdd((Object)be);
                }
                if (InstancedRenderRegistry.shouldSkipRender((BlockEntity)be)) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public static void filterBlockEntityList(Collection<BlockEntity> blockEntities) {
        if (flywheelLoaded) {
            blockEntities.removeIf(InstancedRenderRegistry::shouldSkipRender);
        }
    }

    @SubscribeEvent
    public static void onChunkDataBuilt(ChunkDataBuiltEvent event) {
        if (flywheelLoaded) {
            event.getDataBuilder().removeBlockEntitiesIf(InstancedRenderRegistry::shouldSkipRender);
        }
    }
}

