package me.jellysquid.mods.sodium.client.world;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.*;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import javax.annotation.Nullable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

/**
 * Wrapper object used to defeat identity comparisons in mods. Since vanilla provides a unique object to them for each
 * subchunk, we do the same.
 */
public class WorldSliceLocal implements BlockAndTintGetter {
    private final BlockAndTintGetter view;

    public WorldSliceLocal(BlockAndTintGetter view) {
        this.view = view;
    }

    @Override
    public float m_7717_(Direction direction, boolean shaded) {
        return view.m_7717_(direction, shaded);
    }

    @Override
    public LevelLightEngine m_5518_() {
        return view.m_5518_();
    }

    @Override
    public int m_6171_(BlockPos pos, ColorResolver colorResolver) {
        return view.m_6171_(pos, colorResolver);
    }

    @Override
    public int m_45517_(LightLayer type, BlockPos pos) {
        return view.m_45517_(type, pos);
    }

    @Override
    public int m_45524_(BlockPos pos, int ambientDarkness) {
        return view.m_45524_(pos, ambientDarkness);
    }

    @Override
    public boolean m_45527_(BlockPos pos) {
        return view.m_45527_(pos);
    }

    @Override
    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return view.m_7702_(pos);
    }

    @Override
    public <T extends BlockEntity> Optional<T> m_141902_(BlockPos pos, BlockEntityType<T> type) {
        return view.m_141902_(pos, type);
    }

    @Override
    public BlockState m_8055_(BlockPos pos) {
        return view.m_8055_(pos);
    }

    @Override
    public FluidState m_6425_(BlockPos pos) {
        return view.m_6425_(pos);
    }

    @Override
    public int m_7146_(BlockPos pos) {
        return view.m_7146_(pos);
    }

    @Override
    public int m_7469_() {
        return view.m_7469_();
    }

    @Override
    public Stream<BlockState> m_45556_(AABB box) {
        return view.m_45556_(box);
    }

    @Override
    public BlockHitResult m_151353_(ClipBlockStateContext context) {
        return view.m_151353_(context);
    }

    @Override
    public BlockHitResult m_45547_(ClipContext context) {
        return view.m_45547_(context);
    }

    @Override
    @Nullable
    public BlockHitResult m_45558_(Vec3 start, Vec3 end, BlockPos pos, VoxelShape shape, BlockState state) {
        return view.m_45558_(start, end, pos, shape, state);
    }

    @Override
    public double m_45564_(VoxelShape blockCollisionShape, Supplier<VoxelShape> belowBlockCollisionShapeGetter) {
        return view.m_45564_(blockCollisionShape, belowBlockCollisionShapeGetter);
    }

    @Override
    public double m_45573_(BlockPos pos) {
        return view.m_45573_(pos);
    }

    public static <T, C> T m_151361_(Vec3 start, Vec3 end, C context, BiFunction<C, BlockPos, T> blockHitFactory, Function<C, T> missFactory) {
        return BlockGetter.m_151361_(start, end, context, blockHitFactory, missFactory);
    }

    @Override
    public int m_141928_() {
        return view.m_141928_();
    }

    @Override
    public int m_141937_() {
        return view.m_141937_();
    }

    @Override
    public int m_151558_() {
        return view.m_151558_();
    }

    @Override
    public int m_151559_() {
        return view.m_151559_();
    }

    @Override
    public int m_151560_() {
        return view.m_151560_();
    }

    @Override
    public int m_151561_() {
        return view.m_151561_();
    }

    @Override
    public boolean m_151570_(BlockPos pos) {
        return view.m_151570_(pos);
    }

    @Override
    public boolean m_151562_(int y) {
        return view.m_151562_(y);
    }

    @Override
    public int m_151564_(int y) {
        return view.m_151564_(y);
    }

    @Override
    public int m_151566_(int coord) {
        return view.m_151566_(coord);
    }

    @Override
    public int m_151568_(int index) {
        return view.m_151568_(index);
    }

    public static LevelHeightAccessor m_186487_(int bottomY, int height) {
        return LevelHeightAccessor.m_186487_(bottomY, height);
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public BlockEntity getExistingBlockEntity(BlockPos pos) {
        return view.getExistingBlockEntity(pos);
    }
}
