package me.jellysquid.mods.sodium.client.util.math;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;

public interface Matrix3fExtended {
    /**
     * Applies the specified rotation to this matrix in-place.
     *
     * @param quaternion The quaternion to rotate this matrix by
     */
    void rotate(Quaternion quaternion);

    int computeNormal(Direction dir);

    float transformVecX(float x, float y, float z);

    float transformVecY(float x, float y, float z);

    float transformVecZ(float x, float y, float z);

    default float transformVecX(Vector3f dir) {
        return this.transformVecX(dir.m_122239_(), dir.m_122260_(), dir.m_122269_());
    }

    default float transformVecY(Vector3f dir) {
        return this.transformVecY(dir.m_122239_(), dir.m_122260_(), dir.m_122269_());
    }

    default float transformVecZ(Vector3f dir) {
        return this.transformVecZ(dir.m_122239_(), dir.m_122260_(), dir.m_122269_());
    }

    float getA00();

    float getA10();

    float getA20();

    float getA01();

    float getA11();

    float getA21();

    float getA02();

    float getA12();

    float getA22();
}
