package me.jellysquid.mods.sodium.mixin.features.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.render.*;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@Mixin(DebugScreenOverlay.class)
public abstract class MixinDebugHud {
    @Shadow
    @Final
    private Minecraft client;

    @Shadow
    @Final
    private Font textRenderer;

    private List<String> capturedList = null;

    @Redirect(method = { "renderLeftText", "renderRightText" }, at = @At(value = "INVOKE", target = "Ljava/util/List;size()I"))
    private int preRenderText(List<String> list) {
        // Capture the list to be rendered later
        this.capturedList = list;

        return 0; // Prevent the rendering of any text
    }

    @Inject(method = "renderLeftText", at = @At("RETURN"))
    public void renderLeftText(PoseStack matrixStack, CallbackInfo ci) {
        this.renderCapturedText(matrixStack, false);
    }

    @Inject(method = "renderRightText", at = @At("RETURN"))
    public void renderRightText(PoseStack matrixStack, CallbackInfo ci) {
        this.renderCapturedText(matrixStack, true);
    }

    private void renderCapturedText(PoseStack matrixStack, boolean right) {
        Validate.notNull(this.capturedList, "Failed to capture string list");

        this.renderBackdrop(matrixStack, this.capturedList, right);
        this.renderStrings(matrixStack, this.capturedList, right);

        this.capturedList = null;
    }

    private void renderStrings(PoseStack matrixStack, List<String> list, boolean right) {
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_(Tesselator.m_85913_().m_85915_());

        Matrix4f positionMatrix = matrixStack.m_85850_()
                .m_85861_();

        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);

            if (!Strings.isNullOrEmpty(string)) {
                int height = 9;
                int width = this.textRenderer.m_92895_(string);

                float x1 = right ? this.client.m_91268_().m_85445_() - 2 - width : 2;
                float y1 = 2 + (height * i);

                this.textRenderer.m_92822_(string, x1, y1, 0xe0e0e0, false, positionMatrix, immediate,
                        false, 0, 15728880, this.textRenderer.m_92718_());
            }
        }

        immediate.m_109911_();
    }

    private void renderBackdrop(PoseStack matrixStack, List<String> list, boolean right) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();

        int color = 0x90505050;

        float f = (float) (color >> 24 & 255) / 255.0F;
        float g = (float) (color >> 16 & 255) / 255.0F;
        float h = (float) (color >> 8 & 255) / 255.0F;
        float k = (float) (color & 255) / 255.0F;

        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);

        RenderSystem.m_157427_(GameRenderer::m_172811_);

        Matrix4f matrix = matrixStack.m_85850_()
                .m_85861_();

        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);

            if (Strings.isNullOrEmpty(string)) {
                continue;
            }

            int height = 9;
            int width = this.textRenderer.m_92895_(string);

            int x = right ? this.client.m_91268_().m_85445_() - 2 - width : 2;
            int y = 2 + height * i;

            float x1 = x - 1;
            float y1 = y - 1;
            float x2 = x + width + 1;
            float y2 = y + height - 1;

            bufferBuilder.m_85982_(matrix, x1, y2, 0.0F).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x2, y2, 0.0F).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x2, y1, 0.0F).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x1, y1, 0.0F).m_85950_(g, h, k, f).m_5752_();
        }

        BufferBuilder.RenderedBuffer output = bufferBuilder.m_231175_();

        BufferUploader.m_231202_(output);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}