package me.jellysquid.mods.sodium.client.compat.ccl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class CCLCompat {
	
	public static Map<Holder<Block>, ICCBlockRenderer> customBlockRenderers;
	public static Map<Holder<Fluid>, ICCBlockRenderer> customFluidRenderers;
	public static List<ICCBlockRenderer> customGlobalRenderers;

    public static @NotNull List<ICCBlockRenderer> getCustomRenderers(final @NotNull BlockAndTintGetter world, final @NotNull BlockPos pos) {
        final BlockState state = world.m_8055_(pos);
        final Block block = state.m_60734_();

        final FluidState fluidState = state.m_60819_();
        final Fluid fluid = fluidState.m_76152_();

        if(customGlobalRenderers == null)
        	return new ArrayList<>();
        
        final ArrayList<ICCBlockRenderer> renderers = new ArrayList<>(customGlobalRenderers);

        if(customBlockRenderers != null)
	        for (final Map.Entry<Holder<Block>, ICCBlockRenderer> entry : customBlockRenderers.entrySet()) {
	            final Block entryBlock = entry.getKey().get();
	
	            if (entryBlock == block) {
	                renderers.add(entry.getValue());
	            }
	        }

        if(customFluidRenderers != null)
	        for (final Map.Entry<Holder<Fluid>, ICCBlockRenderer> entry : customFluidRenderers.entrySet()) {
	            final Fluid entryFluid = entry.getKey().get();
	
	            if (entryFluid.m_6212_(fluid)) {
	                renderers.add(entry.getValue());
	            }
	        }

        return renderers;
    }

    
	@SuppressWarnings("unchecked")
	public static void init() {
		try {
			SodiumClientMod.logger().info("Retrieving block renderers");
            final Field blockRenderersField = BlockRenderingRegistry.class.getDeclaredField("blockRenderers");
            blockRenderersField.setAccessible(true);
            customBlockRenderers = (Map<Holder<Block>, ICCBlockRenderer>) blockRenderersField.get(null);

            SodiumClientMod.logger().info("Retrieving fluid renderers");
            final Field fluidRenderersField = BlockRenderingRegistry.class.getDeclaredField("fluidRenderers");
            fluidRenderersField.setAccessible(true);
            customFluidRenderers = (Map<Holder<Fluid>, ICCBlockRenderer>) fluidRenderersField.get(null);

            SodiumClientMod.logger().info("Retrieving global renderers");
            final Field globalRenderersField = BlockRenderingRegistry.class.getDeclaredField("globalRenderers");
            globalRenderersField.setAccessible(true);
            customGlobalRenderers = (List<ICCBlockRenderer>) globalRenderersField.get(null);
        }
        catch (final @NotNull Throwable t) {
        	SodiumClientMod.logger().error("Could not retrieve custom renderers");
        }

	}
	
}
