/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.world.biome.ItemColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemRenderer.class})
public class MixinItemRenderer {
    private final XoroshiroRandomSource random = new XoroshiroRandomSource(42L);
    @Shadow
    @Final
    private ItemColors f_115097_;

    @Overwrite
    public void m_115189_(BakedModel model, ItemStack stack, int light, int overlay, PoseStack matrices, VertexConsumer vertices) {
        XoroshiroRandomSource random = this.random;
        for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(42L);
            List quads = model.m_213637_(null, direction, (RandomSource)random);
            if (quads.isEmpty()) continue;
            this.m_115162_(matrices, vertices, quads, stack, light, overlay);
        }
        random.m_188584_(42L);
        List quads = model.m_213637_(null, null, (RandomSource)random);
        if (!quads.isEmpty()) {
            this.m_115162_(matrices, vertices, quads, stack, light, overlay);
        }
    }

    @Overwrite
    public void m_115162_(PoseStack matrices, VertexConsumer vertexConsumer, List<BakedQuad> quads, ItemStack stack, int light, int overlay) {
        PoseStack.Pose entry = matrices.m_85850_();
        ItemColor colorProvider = null;
        QuadVertexSink drain = VertexDrain.of(vertexConsumer).createSink(VanillaVertexTypes.QUADS);
        drain.ensureCapacity(quads.size() * 4);
        for (BakedQuad bakedQuad : quads) {
            int color = -1;
            if (!stack.m_41619_() && bakedQuad.m_111304_()) {
                if (colorProvider == null) {
                    colorProvider = ((ItemColorsExtended)this.f_115097_).getColorProvider(stack);
                }
                try {
                    color = colorProvider == null ? ColorARGB.toABGR(this.f_115097_.m_92676_(stack, bakedQuad.m_111305_()), 255) : ColorARGB.toABGR(colorProvider.m_92671_(stack, bakedQuad.m_111305_()), 255);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            for (int i = 0; i < 4; ++i) {
                int fColor = this.multARGBInts(quad.getColor(i), color);
                drain.writeQuad(entry, quad.getX(i), quad.getY(i), quad.getZ(i), fColor, quad.getTexU(i), quad.getTexV(i), ModelQuadUtil.mergeBakedLight(quad.getLight(i), light), overlay, ModelQuadUtil.getFacingNormal(bakedQuad.m_111306_(), quad.getNormal(i)));
            }
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
        drain.flush();
    }

    private int multARGBInts(int colorA, int colorB) {
        if (colorA == -1) {
            return colorB;
        }
        if (colorB == -1) {
            return colorA;
        }
        int a = (int)((float)ColorARGB.unpackAlpha(colorA) / 255.0f * ((float)ColorARGB.unpackAlpha(colorB) / 255.0f) * 255.0f);
        int b = (int)((float)ColorARGB.unpackBlue(colorA) / 255.0f * ((float)ColorARGB.unpackBlue(colorB) / 255.0f) * 255.0f);
        int g = (int)((float)ColorARGB.unpackGreen(colorA) / 255.0f * ((float)ColorARGB.unpackGreen(colorB) / 255.0f) * 255.0f);
        int r = (int)((float)ColorARGB.unpackRed(colorA) / 255.0f * ((float)ColorARGB.unpackRed(colorB) / 255.0f) * 255.0f);
        return ColorARGB.pack(r, g, b, a);
    }
}

