package me.jellysquid.mods.sodium.mixin.features.buffer_builder.fast_advance;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import me.jellysquid.mods.sodium.client.buffer.ExtendedVertexFormat;
import net.minecraft.client.render.*;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(BufferBuilder.class)
public abstract class MixinBufferBuilder extends DefaultedVertexConsumer implements BufferVertexConsumer {
    @Shadow
    private VertexFormatElement currentElement;

    @Shadow
    private int elementOffset;

    @Shadow
    private int currentElementId;

    private ExtendedVertexFormat.Element[] embeddium$vertexFormatExtendedElements;
    private ExtendedVertexFormat.Element embeddium$currentExtendedElement;

    @Inject(method = "setFormat",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/render/BufferBuilder;format:Lnet/minecraft/client/render/VertexFormat;",
                    opcode = Opcodes.PUTFIELD
            )
    )
    private void onFormatChanged(VertexFormat format, CallbackInfo ci) {
        embeddium$vertexFormatExtendedElements = ((ExtendedVertexFormat) format).embeddium$getExtendedElements();
        embeddium$currentExtendedElement = embeddium$vertexFormatExtendedElements[0];
    }

    /**
     * @author JellySquid
     * @reason Remove modulo operations, recursion, and list dereference
     */
    @Override
    @Overwrite
    public void m_5751_() {
        if ((currentElementId += embeddium$currentExtendedElement.increment) >= embeddium$vertexFormatExtendedElements.length)
            currentElementId -= embeddium$vertexFormatExtendedElements.length;
        elementOffset += embeddium$currentExtendedElement.byteLength;
        embeddium$currentExtendedElement = embeddium$vertexFormatExtendedElements[currentElementId];
        currentElement = embeddium$currentExtendedElement.actual;

        if (this.f_85824_ && this.currentElement.m_86048_() == VertexFormatElement.Usage.COLOR) {
            BufferVertexConsumer.super.m_6122_(this.f_85825_, this.f_85826_, this.f_85827_, this.f_85828_);
        }
    }
}
