/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.gen.compat;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import noobanidus.mods.lootr.common.api.LootrTags;
import org.jetbrains.annotations.Nullable;

public class LootrCompatBlockTagProvider
extends BlockTagsProvider {
    private final List<String> BARREL_BLOCK_IDS;
    private final List<String> CHEST_BLOCK_IDS;
    private final List<String> TRAPPED_CHEST_BLOCK_IDS;
    private final List<String> SHULKER_BOX_BLOCK_IDS;
    private final String COMPAT_MODID;

    public LootrCompatBlockTagProvider(String compatModid, @Nullable List<String> barrelBlockIds, @Nullable List<String> chestBlockIds, @Nullable List<String> trappedBlockIds, @Nullable List<String> shulkerBoxIds, DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(generator.getPackOutput(), lookupProvider, "lootr");
        this.COMPAT_MODID = compatModid;
        this.BARREL_BLOCK_IDS = barrelBlockIds == null ? List.of() : barrelBlockIds;
        this.CHEST_BLOCK_IDS = chestBlockIds == null ? List.of() : chestBlockIds;
        this.SHULKER_BOX_BLOCK_IDS = shulkerBoxIds == null ? List.of() : shulkerBoxIds;
        this.TRAPPED_CHEST_BLOCK_IDS = trappedBlockIds == null ? List.of() : trappedBlockIds;
    }

    protected void addTags(HolderLookup.Provider provider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag;
        if (!this.CHEST_BLOCK_IDS.isEmpty()) {
            tag = this.tag(LootrTags.Blocks.CONVERT_CHESTS);
            for (String block : this.CHEST_BLOCK_IDS) {
                tag.add(TagEntry.optionalElement((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.COMPAT_MODID, (String)block)));
            }
        }
        if (!this.BARREL_BLOCK_IDS.isEmpty()) {
            tag = this.tag(LootrTags.Blocks.CONVERT_BARRELS);
            for (String block : this.BARREL_BLOCK_IDS) {
                tag.add(TagEntry.optionalElement((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.COMPAT_MODID, (String)block)));
            }
        }
        if (!this.TRAPPED_CHEST_BLOCK_IDS.isEmpty()) {
            tag = this.tag(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS);
            for (String block : this.TRAPPED_CHEST_BLOCK_IDS) {
                tag.add(TagEntry.optionalElement((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.COMPAT_MODID, (String)block)));
            }
        }
        if (!this.SHULKER_BOX_BLOCK_IDS.isEmpty()) {
            tag = this.tag(LootrTags.Blocks.CONVERT_SHULKERS);
            for (String block : this.SHULKER_BOX_BLOCK_IDS) {
                tag.add(TagEntry.optionalElement((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.COMPAT_MODID, (String)block)));
            }
        }
    }

    public String getName() {
        return this.COMPAT_MODID + " Compatibility Block Tags";
    }
}

