/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.mixins;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.FileUtil;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.Level;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.mixins.AccessorMixinDimensionDataStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
public class MixinServerChunkCache {
    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/chunk/ChunkGenerator;IIZLnet/minecraft/server/level/progress/ChunkProgressListener;Lnet/minecraft/world/level/entity/ChunkStatusUpdateListener;Ljava/util/function/Supplier;)V"}, at={@At(value="RETURN")})
    private void LootrServerChunkCacheInit(CallbackInfo ci) {
        ServerChunkCache cache = (ServerChunkCache)this;
        if (!cache.getLevel().dimension().equals(Level.OVERWORLD)) {
            return;
        }
        Path lootrDirectory = ((AccessorMixinDimensionDataStorage)cache.getDataStorage()).getDataFolder().resolve("lootr");
        try {
            FileUtil.createDirectoriesSafe((Path)lootrDirectory);
            for (String digit : LootrAPI._lootr$digits) {
                Path subPath1 = lootrDirectory.resolve(digit);
                FileUtil.createDirectoriesSafe((Path)subPath1);
                for (String digit2 : LootrAPI._lootr$digits) {
                    Path subPath2 = subPath1.resolve(digit + digit2);
                    FileUtil.createDirectoriesSafe((Path)subPath2);
                }
            }
        }
        catch (IOException e) {
            LootrAPI.LOG.error("Failed to create initial Lootr data directory: {}", (Object)lootrDirectory);
        }
    }
}

