/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.data;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.data.LootrInventory;
import org.jetbrains.annotations.Nullable;

public class LootrSavedData
extends SavedData
implements ILootrSavedData {
    private boolean hasBeenOpened;
    private ILootrInfo info;
    private final Map<UUID, LootrInventory> inventories = new HashMap<UUID, LootrInventory>();
    private final Set<UUID> openers = new ObjectLinkedOpenHashSet();
    private final Set<UUID> actualOpeners = new ObjectLinkedOpenHashSet();

    protected LootrSavedData(ILootrInfo info) {
        this(info, false);
    }

    protected LootrSavedData(ILootrInfo info, boolean noCopy) {
        this.info = noCopy ? info : BaseLootrInfo.copy(info);
    }

    public static Supplier<LootrSavedData> fromInfo(ILootrInfo info) {
        return () -> new LootrSavedData(info);
    }

    public static LootrSavedData load(CompoundTag compound, HolderLookup.Provider provider) {
        ILootrInfo info = ILootrInfo.loadInfoFromTag(compound, provider);
        LootrSavedData data = new LootrSavedData(info, true);
        data.inventories.clear();
        data.openers.clear();
        data.actualOpeners.clear();
        ListTag compounds = compound.getList("inventories", 10);
        for (int i = 0; i < compounds.size(); ++i) {
            CompoundTag thisTag = compounds.getCompound(i);
            CompoundTag itemTag = thisTag.getCompound("chest");
            NonNullList<ItemStack> items = info.buildInitialInventory();
            ContainerHelper.loadAllItems((CompoundTag)itemTag, items, (HolderLookup.Provider)provider);
            UUID uuid = thisTag.getUUID("uuid");
            data.inventories.put(uuid, new LootrInventory(data, items));
        }
        if (compound.contains("openers")) {
            ListTag openers = compound.getList("openers", 11);
            for (Tag opener : openers) {
                data.openers.add(NbtUtils.loadUUID((Tag)opener));
            }
        }
        if (compound.contains("actualOpeners")) {
            ListTag openers = compound.getList("actualOpeners", 11);
            for (Tag opener : openers) {
                data.actualOpeners.add(NbtUtils.loadUUID((Tag)opener));
            }
        }
        if (compound.contains("hasBeenOpened")) {
            data.hasBeenOpened = compound.getBoolean("hasBeenOpened");
        }
        return data;
    }

    @Override
    public ILootrInfo getRedirect() {
        return this.info;
    }

    @Override
    public Set<UUID> getVisualOpeners() {
        return this.openers;
    }

    @Override
    public boolean addVisualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.addVisualOpener(uuid);
        if (result) {
            this.setDirty();
        }
        return result;
    }

    @Override
    public boolean removeVisualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.removeVisualOpener(uuid);
        if (result) {
            this.setDirty();
        }
        return result;
    }

    @Override
    public boolean addActualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.addActualOpener(uuid);
        if (result) {
            this.setDirty();
        }
        return result;
    }

    private void removeOpener(UUID uuid) {
        Set<UUID> visualOpeners = this.getVisualOpeners();
        if (visualOpeners != null && visualOpeners.remove(uuid)) {
            this.setDirty();
        }
    }

    @Override
    public Set<UUID> getActualOpeners() {
        return this.actualOpeners;
    }

    @Override
    public void markChanged() {
        this.setDirty();
    }

    @Override
    public void markDataChanged() {
        this.markChanged();
    }

    @Override
    @Nullable
    public LootrInventory getInventory(UUID id) {
        LootrInventory inventory = this.inventories.get(id);
        if (inventory != null) {
            inventory.setInfo(this);
        }
        return inventory;
    }

    @Override
    public LootrInventory createInventory(ILootrInfoProvider provider, ServerPlayer player, LootFiller filler) {
        LootrInventory result = new LootrInventory(this, provider.buildInitialInventory());
        if (!LootrAPI.isFakePlayer((Player)player)) {
            filler.unpackLootTable(provider, (Player)player, result);
        }
        this.inventories.put(player.getUUID(), result);
        this.hasBeenOpened = true;
        this.setDirty();
        return result;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        this.info.saveInfoToTag(compound, provider);
        ListTag compounds = new ListTag();
        for (Map.Entry<UUID, LootrInventory> entry : this.inventories.entrySet()) {
            CompoundTag thisTag = new CompoundTag();
            thisTag.putUUID("uuid", entry.getKey());
            thisTag.put("chest", (Tag)entry.getValue().saveToTag(provider));
            compounds.add((Object)thisTag);
        }
        compound.put("inventories", (Tag)compounds);
        ListTag openers = new ListTag();
        for (UUID opener : this.openers) {
            openers.add((Object)NbtUtils.createUUID((UUID)opener));
        }
        compound.put("openers", (Tag)openers);
        ListTag listTag = new ListTag();
        for (UUID opener : this.actualOpeners) {
            listTag.add((Object)NbtUtils.createUUID((UUID)opener));
        }
        compound.put("actualOpeners", (Tag)listTag);
        compound.putBoolean("hasBeenOpened", this.hasBeenOpened);
        return compound;
    }

    @Override
    public void update(ILootrInfo info) {
        BaseLootrInfo infoCopy = BaseLootrInfo.copy(info);
        if (!infoCopy.equals(this.info)) {
            this.markChanged();
            this.info = info;
        }
    }

    @Override
    public void refresh() {
        this.inventories.clear();
        this.hasBeenOpened = false;
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return false;
    }

    @Override
    public boolean clearInventories(UUID id) {
        if (this.inventories.remove(id) != null) {
            this.removeOpener(id);
            this.setDirty();
            return true;
        }
        return false;
    }
}

