/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BarrelModel
implements UnbakedModel {
    private final ResourceLocation opened;
    private final ResourceLocation unopened;
    private final ResourceLocation vanilla;
    private final ResourceLocation old_opened;
    private final ResourceLocation old_unopened;
    private final ResourceLocation parentLocation;
    private final boolean ambientOcclusion;
    private final UnbakedModel.GuiLight guiLight;
    private final ItemTransforms itemTransforms;
    private final TextureSlots.Data textures;
    private final BakedBarrelModelBuilder builder;
    private boolean useParent;
    private UnbakedModel parent;

    public BarrelModel(BakedBarrelModelBuilder builder, ResourceLocation parent, ResourceLocation opened, ResourceLocation unopened, ResourceLocation vanilla, ResourceLocation old_unopened, ResourceLocation old_opened) {
        this(builder, true, UnbakedModel.GuiLight.SIDE, ItemTransforms.NO_TRANSFORMS, TextureSlots.Data.EMPTY, parent, opened, unopened, vanilla, old_unopened, old_opened);
        this.useParent = true;
    }

    public BarrelModel(BakedBarrelModelBuilder builder, boolean ambientOcclusion, UnbakedModel.GuiLight guiLight, ItemTransforms transforms, TextureSlots.Data textures, ResourceLocation parent, ResourceLocation opened, ResourceLocation unopened, ResourceLocation vanilla, ResourceLocation old_unopened, ResourceLocation old_opened) {
        this.builder = builder;
        this.opened = opened;
        this.unopened = unopened;
        this.vanilla = vanilla;
        this.old_opened = old_opened;
        this.old_unopened = old_unopened;
        this.parentLocation = parent;
        this.ambientOcclusion = ambientOcclusion;
        this.guiLight = guiLight;
        this.itemTransforms = transforms;
        this.textures = textures;
        this.useParent = false;
    }

    @Nullable
    public Boolean getAmbientOcclusion() {
        if (this.useParent) {
            if (this.parent != null) {
                return this.parent.getAmbientOcclusion();
            }
            return true;
        }
        return this.ambientOcclusion;
    }

    @Nullable
    public UnbakedModel.GuiLight getGuiLight() {
        if (this.useParent) {
            if (this.parent != null) {
                return this.parent.getGuiLight();
            }
            return UnbakedModel.GuiLight.SIDE;
        }
        return this.guiLight;
    }

    @Nullable
    public ItemTransforms getTransforms() {
        if (this.useParent) {
            if (this.parent != null) {
                return this.parent.getTransforms();
            }
            return ItemTransforms.NO_TRANSFORMS;
        }
        return this.itemTransforms;
    }

    public TextureSlots.Data getTextureSlots() {
        if (this.useParent) {
            if (this.parent != null) {
                return this.parent.getTextureSlots();
            }
            return TextureSlots.Data.EMPTY;
        }
        return this.textures;
    }

    public BakedModel bake(TextureSlots textures, ModelBaker baker, ModelState modelState, boolean useAmbientOcclusion, boolean usesBlockLight, ItemTransforms itemTransforms) {
        return this.builder.build(useAmbientOcclusion, usesBlockLight, textures.getMaterial("particle"), baker.bake(this.opened, modelState), baker.bake(this.unopened, modelState), baker.bake(this.vanilla, modelState), baker.bake(this.old_opened, modelState), baker.bake(this.old_unopened, modelState), itemTransforms);
    }

    public void resolveDependencies(ResolvableModel.Resolver modelGetter) {
        modelGetter.resolve(this.opened);
        modelGetter.resolve(this.unopened);
        modelGetter.resolve(this.vanilla);
        modelGetter.resolve(this.old_opened);
        modelGetter.resolve(this.old_unopened);
        this.parent = modelGetter.resolve(this.parentLocation);
    }

    @Nullable
    public UnbakedModel getParent() {
        return this.parent;
    }

    @FunctionalInterface
    public static interface BakedBarrelModelBuilder {
        public BakedModel build(boolean var1, boolean var2, Material var3, BakedModel var4, BakedModel var5, BakedModel var6, BakedModel var7, BakedModel var8, ItemTransforms var9);
    }
}

