/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrophyBlock
extends Block {
    private static final VoxelShape EAST_WEST = Block.box((double)1.5, (double)0.0, (double)4.0, (double)14.5, (double)14.5, (double)12.0);
    private static final VoxelShape NORTH_SOUTH = Block.box((double)4.0, (double)0.0, (double)1.5, (double)12.0, (double)14.5, (double)14.5);

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return EAST_WEST;
        }
        return NORTH_SOUTH;
    }

    public BlockState rotate(BlockState p_60530_, Rotation p_60531_) {
        return (BlockState)p_60530_.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)p_60531_.rotate((Direction)p_60530_.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState p_60528_, Mirror p_60529_) {
        return p_60528_.rotate(p_60529_.getRotation((Direction)p_60528_.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }
}

