package noobanidus.mods.lootr.common.api;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.client.ClientTextureType;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.filter.ILootrFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class LootrAPI {
  public static final Logger LOG = LogManager.getLogger();
  public static final String MODID = "lootr";
  public static final String NETWORK_VERSION = "lootr-1.21.0-1";
  public static final ResourceKey<LootTable> ELYTRA_CHEST = ResourceKey.create(Registries.LOOT_TABLE, LootrAPI.rl("chests/elytra"));
  public static final ResourceKey<LootTable> TROPHY_REWARD = ResourceKey.create(Registries.LOOT_TABLE, LootrAPI.rl("reward/trophy"));
  public static final TicketType<Unit> LOOTR_ENTITY_TICK_TICKET = TicketType.create("lootr_entity_tick_ticket", (unit1, unit2) -> 0, 300);
  @ApiStatus.Internal
  public static final List<String> _lootr$digits = Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f");
  public static final List<ResourceLocation> PROBLEMATIC_CHESTS = Arrays.asList(LootrAPI.rl("twilightforest", "structures/stronghold_boss"), LootrAPI.rl("atum", "chests/pharaoh"));

  public static ILootrAPI INSTANCE = null;
  public static boolean shouldDiscardIdAndOpeners;

  public static boolean isReady () {
    return INSTANCE != null;
  }

  public static ResourceLocation rl(String path) {
    return ResourceLocation.fromNamespaceAndPath(MODID, path);
  }

  public static ResourceLocation rl(String namespace, String path) {
    return ResourceLocation.fromNamespaceAndPath(namespace, path);
  }

  public static Set<UUID> getPlayerIds() {
    return INSTANCE.getPlayerIds();
  }

  public static MinecraftServer getServer() {
    return INSTANCE.getServer();
  }

  public static int getCurrentTicks() {
    return INSTANCE.getCurrentTicks();
  }

  public static boolean isFakePlayer(Player player) {
    return INSTANCE.isFakePlayer(player);
  }

  public static boolean clearPlayerLoot(ServerPlayer entity) {
    return INSTANCE.clearPlayerLoot(entity);
  }

  public static boolean clearPlayerLoot(UUID id) {
    return INSTANCE.clearPlayerLoot(id);
  }

  public static long getLootSeed(long seed) {
    return INSTANCE.getLootSeed(seed);
  }

  public static boolean shouldDiscard() {
    return INSTANCE.shouldDiscard();
  }

  public static float getExplosionResistance(Block block, float defaultResistance) {
    return INSTANCE.getExplosionResistance(block, defaultResistance);
  }

  public static boolean isBlastResistant() {
    return INSTANCE.isBlastResistant();
  }

  public static boolean isBlastImmune() {
    return INSTANCE.isBlastImmune();
  }

  public static float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos position, float defaultProgress) {
    return INSTANCE.getDestroyProgress(state, player, level, position, defaultProgress);
  }

  public static int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos, int defaultSignal) {
    return INSTANCE.getAnalogOutputSignal(pBlockState, pLevel, pPos, defaultSignal);
  }

  public static boolean shouldPowerComparators() {
    return INSTANCE.shouldPowerComparators();
  }

  public static ClientTextureType getTextureType() {
    return INSTANCE.getTextureType();
  }

  public static boolean isOldTextures() {
    return INSTANCE.isOldTextures();
  }

  public static boolean isNewTextures () {
    return INSTANCE.isNewTextures();
  }

  public static boolean isVanillaTextures() {
    return INSTANCE.isVanillaTextures();
  }

  public static boolean isDefaultTextures() {
    return INSTANCE.isDefaultTextures();
  }

  public static boolean shouldNotify(int remaining) {
    return INSTANCE.shouldNotify(remaining);
  }

  public static int getNotificationDelay() {
    return INSTANCE.getNotificationDelay();
  }

  public static boolean isNotificationsEnabled() {
    return INSTANCE.isNotificationsEnabled();
  }

  public static boolean isDisabled() {
    return INSTANCE.isDisabled();
  }

  public static boolean isLootTableBlacklisted(ResourceKey<LootTable> table) {
    return INSTANCE.isLootTableBlacklisted(table);
  }

  public static boolean isDimensionBlocked(ResourceKey<Level> dimension) {
    return INSTANCE.isDimensionBlocked(dimension);
  }

  public static Set<ResourceKey<Level>> getDimensionBlacklist() {
    return INSTANCE.getDimensionBlacklist();
  }

  public static Set<ResourceKey<Level>> getDimensionWhitelist() {
    return INSTANCE.getDimensionWhitelist();
  }

  public static Set<ResourceKey<LootTable>> getLootTableBlacklist() {
    return INSTANCE.getLootTableBlacklist();
  }

  public static Set<String> getLootModidBlacklist() {
    return INSTANCE.getLootModidBlacklist();
  }

  public static Set<String> getModidDimensionWhitelist() {
    return INSTANCE.getModidDimensionWhitelist();
  }

  public static Set<String> getModidDimensionBlacklist() {
    return INSTANCE.getModidDimensionBlacklist();
  }

  public static boolean isDecaying(ILootrInfoProvider provider) {
    return INSTANCE.isDecaying(provider);
  }


  public static Set<String> getModidDecayWhitelist() {
    return INSTANCE.getModidDecayWhitelist();
  }

  public static Set<ResourceKey<LootTable>> getDecayWhitelist() {
    return INSTANCE.getDecayWhitelist();
  }

  public static Set<ResourceKey<Level>> getDecayDimensions() {
    return INSTANCE.getDecayDimensions();
  }

  public static Set<String> getRefreshModids() {
    return INSTANCE.getRefreshModids();
  }

  public static Set<ResourceKey<LootTable>> getRefreshWhitelist() {
    return INSTANCE.getRefreshWhitelist();
  }

  public static Set<ResourceKey<Level>> getRefreshDimensions() {
    return INSTANCE.getRefreshDimensions();
  }

  public static boolean isRefreshing(ILootrInfoProvider provider) {
    return INSTANCE.isRefreshing(provider);
  }

  public static boolean reportUnresolvedTables() {
    return INSTANCE.reportUnresolvedTables();
  }

  public static boolean isCustomTrapped() {
    return INSTANCE.isCustomTrapped();
  }

  public static boolean isWorldBorderSafe(Level level, BlockPos pos) {
    return INSTANCE.isWorldBorderSafe(level, pos);
  }

  public static boolean isWorldBorderSafe(Level level, ChunkPos pos) {
    return INSTANCE.isWorldBorderSafe(level, pos);
  }

  public static boolean shouldCheckWorldBorder() {
    return INSTANCE.shouldCheckWorldBorder();
  }

  public static int getMaximumAge() {
    return INSTANCE.getMaximumAge();
  }

  public static boolean hasExpired(long time) {
    return INSTANCE.hasExpired(time);
  }

  public static boolean shouldConvertMineshafts() {
    return INSTANCE.shouldConvertMineshafts();
  }

  public static boolean shouldConvertElytras() {
    return INSTANCE.shouldConvertElytras();
  }

  public static int getDecayValue() {
    return INSTANCE.getDecayValue();
  }

  public static boolean shouldDecayAll() {
    return INSTANCE.shouldDecayAll();
  }

  public static int getRefreshValue() {
    return INSTANCE.getRefreshValue();
  }

  public static boolean shouldRefreshAll() {
    return INSTANCE.shouldRefreshAll();
  }

  public static boolean isMessageStylesEnabled() {
    return INSTANCE.isMessageStylesEnabled();
  }

  public static Style getInvalidStyle() {
    return INSTANCE.getInvalidStyle();
  }

  public static Style getDecayStyle() {
    return INSTANCE.getDecayStyle();
  }

  public static Style getRefreshStyle() {
    return INSTANCE.getRefreshStyle();
  }

  public static Style getChatStyle() {
    return INSTANCE.getChatStyle();
  }

  public static Component getInvalidTableComponent(ResourceKey<LootTable> lootTable) {
    return INSTANCE.getInvalidTableComponent(lootTable);
  }

  public static boolean canDestroyOrBreak(Player player) {
    return INSTANCE.canDestroyOrBreak(player);
  }

  public static boolean isBreakDisabled() {
    return INSTANCE.isBreakDisabled();
  }

  public static boolean isBreakEnabled() {
    return INSTANCE.isBreakEnabled();
  }

  public static boolean isFakePlayerBreakEnabled() {
    return INSTANCE.isFakePlayerBreakEnabled();
  }

  public static boolean shouldDropPlayerLoot () {
    return INSTANCE.shouldDropPlayerLoot();
  }

  public static boolean shouldPerformDecayWhileTicking() {
    return INSTANCE.shouldPerformDecayWhileTicking();
  }

  public static boolean shouldPerformRefreshWhileTicking() {
    return INSTANCE.shouldPerformRefreshWhileTicking();
  }

  public static boolean shouldStartDecayWhileTicking() {
    return INSTANCE.shouldStartDecayWhileTicking();
  }

  public static boolean shouldStartRefreshWhileTicking() {
    return INSTANCE.shouldStartRefreshWhileTicking();
  }

  public static boolean performPiecewiseCheck() {
    return INSTANCE.performPiecewiseCheck();
  }

  public static BlockState replacementBlockState(BlockState original) {
    return INSTANCE.replacementBlockState(original);
  }

  @Nullable
  public static ILootrInventory getInventory(ILootrInfoProvider provider, ServerPlayer player, LootFiller filler) {
    return INSTANCE.getInventory(provider, player, filler);
  }

  @Nullable
  public static ILootrInventory getInventory(ILootrInfoProvider provider, ServerPlayer player, LootFiller filler, MenuBuilder builder) {
    return INSTANCE.getInventory(provider, player, filler, builder);
  }

  @Nullable
  public static ILootrSavedData getData(ILootrInfoProvider provider) {
    return INSTANCE.getData(provider);
  }

  public static boolean isAwarded(ILootrInfoProvider provider, ServerPlayer player) {
    return INSTANCE.isAwarded(provider, player);
  }

  public static boolean isAwarded(UUID uuid, ServerPlayer player) {
    return INSTANCE.isAwarded(uuid, player);
  }

  public static void award(ILootrInfoProvider provider, ServerPlayer player) {
    INSTANCE.award(provider, player);
  }

  public static void award(UUID id, ServerPlayer player) {
    INSTANCE.award(id, player);
  }

  public static int getRemainingDecayValue(ILootrInfoProvider provider) {
    return INSTANCE.getRemainingDecayValue(provider);
  }

  public static boolean isDecayed(ILootrInfoProvider provider) {
    return INSTANCE.isDecayed(provider);
  }

  public static void setDecaying(ILootrInfoProvider provider) {
    INSTANCE.setDecaying(provider);
  }

  public static void removeDecayed(ILootrInfoProvider provider) {
    INSTANCE.removeDecayed(provider);
  }

  public static int getRemainingRefreshValue(ILootrInfoProvider provider) {
    return INSTANCE.getRemainingRefreshValue(provider);
  }

  public static boolean isRefreshed(ILootrInfoProvider provider) {
    return INSTANCE.isRefreshed(provider);
  }

  public static void setRefreshing(ILootrInfoProvider provider) {
    INSTANCE.setRefreshing(provider);
  }

  public static void removeRefreshed(ILootrInfoProvider provider) {
    INSTANCE.removeRefreshed(provider);
  }

  public static void handleProviderOpen(@Nullable ILootrInfoProvider provider, ServerPlayer player) {
    INSTANCE.handleProviderOpen(provider, player);
  }

  public static void handleProviderSneak(@Nullable ILootrInfoProvider provider, ServerPlayer player) {
    INSTANCE.handleProviderSneak(provider, player);
  }

  public static void handleProviderTick(@Nullable ILootrInfoProvider provider) {
    INSTANCE.handleProviderTick(provider);
  }

  public static boolean anyUnloadedChunks(ResourceKey<Level> dimension, Set<ChunkPos> chunks) {
    return INSTANCE.anyUnloadedChunks(dimension, chunks);
  }

  public static <T extends BlockEntity> ILootrBlockEntity resolveBlockEntity (T blockEntity) {
    return INSTANCE.resolveBlockEntity(blockEntity);
  }

  public static <T extends Entity> ILootrCart resolveEntity (T entity) {
    return INSTANCE.resolveEntity(entity);
  }

  public static boolean isTaggedStructurePresent (ServerLevel level, ChunkPos chunkPos, TagKey<Structure> tag, BlockPos pos) {
    return INSTANCE.isTaggedStructurePresent(level, chunkPos, tag, pos);
  }

  public static void playerDestroyed (Level level, Player player, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
    INSTANCE.playerDestroyed(level, player, blockPos, blockEntity);
  }

  public static void refreshSections () {
    INSTANCE.refreshSections();
  }

  public static List<ILootrFilter> getFilters () {
    return INSTANCE.getFilters();
  }
}
