/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ILootrInfo {
    public static final Codec<ILootrInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootrBlockType.CODEC.fieldOf("blockType").forGetter(ILootrInfo::getInfoBlockType), (App)LootrInfoType.CODEC.fieldOf("type").forGetter(ILootrInfo::getInfoType), (App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(ILootrInfo::getInfoUUID), (App)Codec.STRING.fieldOf("key").forGetter(ILootrInfo::getInfoKey), (App)BlockPos.CODEC.fieldOf("position").forGetter(ILootrInfo::getInfoPos), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(i -> Optional.ofNullable(i.getInfoDisplayName())), (App)ResourceLocation.CODEC.xmap(loc -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc), ResourceKey::location).fieldOf("dimension").forGetter(ILootrInfo::getInfoDimension), (App)Codec.INT.fieldOf("size").forGetter(ILootrInfo::getInfoContainerSize), (App)ItemStack.OPTIONAL_CODEC.listOf().xmap(list -> NonNullList.of((Object)ItemStack.EMPTY, (Object[])list.toArray(new ItemStack[0])), list -> list).optionalFieldOf("reference").forGetter(info -> info.isInfoReferenceInventory() ? Optional.ofNullable(info.getInfoReferenceInventory()) : Optional.empty()), (App)ResourceLocation.CODEC.xmap(loc -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)loc), ResourceKey::location).optionalFieldOf("table").forGetter(i -> Optional.ofNullable(i.getInfoLootTable())), (App)Codec.LONG.optionalFieldOf("seed").forGetter(info -> info.getInfoLootTable() != null ? Optional.of(info.getInfoLootSeed()) : Optional.empty())).apply((Applicative)instance, BaseLootrInfo::new));

    public LootrBlockType getInfoBlockType();

    public LootrInfoType getInfoType();

    @NotNull
    default public Vec3 getInfoVec() {
        return Vec3.atCenterOf((Vec3i)this.getInfoPos());
    }

    @NotNull
    public UUID getInfoUUID();

    public String getInfoKey();

    public static String generateInfoKey(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public boolean hasBeenOpened();

    public boolean isPhysicallyOpen();

    @NotNull
    public BlockPos getInfoPos();

    @Nullable
    public Component getInfoDisplayName();

    @NotNull
    public ResourceKey<Level> getInfoDimension();

    public int getInfoContainerSize();

    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory();

    public boolean isInfoReferenceInventory();

    @Nullable
    public ResourceKey<LootTable> getInfoLootTable();

    public long getInfoLootSeed();

    @Nullable
    default public Level getInfoLevel() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            return null;
        }
        return server.getLevel(this.getInfoDimension());
    }

    @Nullable
    default public Container getInfoContainer() {
        BlockEntity be;
        ServerLevel level;
        Level level2 = this.getInfoLevel();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return null;
        }
        if (this.getInfoType() == LootrInfoType.CONTAINER_ENTITY) {
            Entity entity = level.getEntity(this.getInfoUUID());
            if (entity instanceof Container) {
                Container container = (Container)entity;
                return container;
            }
        } else if (this.getInfoType() == LootrInfoType.CONTAINER_BLOCK_ENTITY && (be = level.getBlockEntity(this.getInfoPos())) instanceof Container) {
            Container container = (Container)be;
            return container;
        }
        return null;
    }

    default public NonNullList<ItemStack> buildInitialInventory() {
        return NonNullList.withSize((int)this.getInfoContainerSize(), (Object)ItemStack.EMPTY);
    }

    public static enum LootrInfoType implements StringRepresentable
    {
        CONTAINER_BLOCK_ENTITY,
        CONTAINER_ENTITY;

        public static final Codec<LootrInfoType> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LootrInfoType::values);
        }
    }
}

