/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.NewTickingData;
import noobanidus.mods.lootr.common.api.data.TickingData;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import noobanidus.mods.lootr.common.command.IOUtil;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinDimensionDataStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DataStorage {
    @Deprecated
    public static final String ADVANCEMENTS = "lootr/Lootr-AdvancementData";
    @Deprecated
    public static final String DECAYS = "lootr/Lootr-DecayData";
    @Deprecated
    public static final String REFRESHES = "lootr/Lootr-RefreshData";

    @ApiStatus.Internal
    @Nullable
    public static DimensionDataStorage getDataStorage() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        ServerLevel overworld = server.overworld();
        if (overworld == null) {
            LootrAPI.LOG.error("The Overworld is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        return overworld.getDataStorage();
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isAwarded(ILootrInfoProvider provider, ServerPlayer player) {
        return DataStorage.isAwarded(provider.getInfoUUID(), player);
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isAwarded(UUID uuid, ServerPlayer player) {
        return false;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void award(ILootrInfoProvider provider, ServerPlayer player) {
        DataStorage.award(provider.getInfoUUID(), player);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void award(UUID id, ServerPlayer player) {
    }

    @ApiStatus.Internal
    public static int getDecayValue(ILootrInfoProvider provider) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().isClientSide()) {
                return -1;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the decay value for {}.", (Object)provider.getInfoUUID());
            return -1;
        }
        MinecraftServer server = LootrAPI.getServer();
        TickingData oldData = (TickingData)manager.computeIfAbsent(TickingData.FACTORY, DECAYS);
        NewTickingData data = NewTickingData.getRefreshData();
        data.migrateOldData(server, oldData);
        return (int)data.howLongUntilComplete(server, provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static boolean isDecayed(ILootrInfoProvider provider) {
        return DataStorage.getDecayValue(provider) == 0;
    }

    @ApiStatus.Internal
    public static void setDecaying(ILootrInfoProvider provider) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().isClientSide()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the decay value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData oldData = (TickingData)manager.computeIfAbsent(TickingData.FACTORY, DECAYS);
        NewTickingData data = NewTickingData.getDecayData();
        MinecraftServer server = LootrAPI.getServer();
        data.migrateOldData(server, oldData);
        data.setCompletesIn(server, provider.getInfoUUID(), LootrAPI.getDecayValue());
    }

    @ApiStatus.Internal
    public static void removeDecayed(ILootrInfoProvider provider) {
    }

    @Deprecated
    @ApiStatus.Internal
    public static void doTick() {
    }

    @ApiStatus.Internal
    public static int getRefreshValue(ILootrInfoProvider provider) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().isClientSide()) {
                return -1;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the refresh value for {}.", (Object)provider.getInfoUUID());
            return -1;
        }
        TickingData oldData = (TickingData)manager.computeIfAbsent(TickingData.FACTORY, REFRESHES);
        NewTickingData data = NewTickingData.getRefreshData();
        MinecraftServer server = LootrAPI.getServer();
        data.migrateOldData(server, oldData);
        return (int)data.howLongUntilComplete(server, provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static boolean isRefreshed(ILootrInfoProvider provider) {
        return DataStorage.getRefreshValue(provider) == 0;
    }

    @ApiStatus.Internal
    public static void setRefreshing(ILootrInfoProvider provider) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().isClientSide()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the refresh value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData data = (TickingData)manager.computeIfAbsent(TickingData.FACTORY, REFRESHES);
        NewTickingData newData = NewTickingData.getRefreshData();
        MinecraftServer server = LootrAPI.getServer();
        newData.migrateOldData(server, data);
        newData.setCompletesIn(server, provider.getInfoUUID(), LootrAPI.getRefreshValue());
    }

    @ApiStatus.Internal
    public static void removeRefreshed(ILootrInfoProvider provider) {
    }

    @ApiStatus.Internal
    public static LootrSavedData getData(ILootrInfoProvider provider) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().isClientSide()) {
                return null;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch data for {} at {} with ID {} and cannot continue.", provider.getInfoDimension(), (Object)provider.getInfoPos(), (Object)provider.getInfoUUID());
            return null;
        }
        LootrSavedData result = (LootrSavedData)manager.computeIfAbsent(new SavedData.Factory(LootrSavedData.fromInfo(provider), LootrSavedData::load, null), provider.getInfoKey());
        result.update(provider);
        return result;
    }

    @Nullable
    public static ILootrInventory getInventory(ILootrInfoProvider provider, ServerPlayer player, LootFiller filler) {
        LootrSavedData data = DataStorage.getData(provider);
        if (data == null) {
            return null;
        }
        return data.getOrCreateInventory(provider, player, filler);
    }

    @ApiStatus.Internal
    public static boolean clearInventories(Player player) {
        return DataStorage.clearInventories(player.getUUID());
    }

    public static Set<String> getAllLootrFiles() {
        DimensionDataStorage data = DataStorage.getDataStorage();
        if (data == null) {
            return Collections.emptySet();
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return Collections.emptySet();
        }
        Path dataPath = server.getWorldPath(new LevelResource("data")).resolve("lootr");
        HashSet<String> files = new HashSet<String>();
        for (String cache : ((AccessorMixinDimensionDataStorage)data).getCache().keySet()) {
            if (!cache.startsWith("lootr/") || cache.startsWith("lootr/Lootr-") || cache.startsWith("lootr/lootr-")) continue;
            files.add(cache);
        }
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String fileName = path.getFileName().toString();
                    if (fileName.startsWith("lootr-") || fileName.startsWith("Lootr-")) {
                        return;
                    }
                    files.add("lootr/" + fileName.charAt(0) + "/" + fileName.substring(0, 2) + "/" + fileName.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return files;
        }
        return files;
    }

    @ApiStatus.Internal
    public static boolean clearInventories(UUID id) {
        DimensionDataStorage data = DataStorage.getDataStorage();
        if (data == null) {
            return false;
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return false;
        }
        Set<String> files = DataStorage.getAllLootrFiles();
        int count = 0;
        for (String file : files) {
            SavedData datum = data.get(new SavedData.Factory(() -> LootrDummyData.INSTANCE, LootrSavedData::load, null), file);
            if (datum == LootrDummyData.INSTANCE) {
                LootrAPI.LOG.error("Failed to load data for {}, removing from cache.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            if (!(datum instanceof LootrSavedData)) {
                LootrAPI.LOG.error("Data for {} is not a LootrSavedData instance.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            LootrSavedData lootrSavedData = (LootrSavedData)datum;
            if (!lootrSavedData.hasBeenOpened() || !lootrSavedData.clearInventories(id)) continue;
            ++count;
            ServerLevel level = server.getLevel(lootrSavedData.getInfoDimension());
            if (level == null) continue;
            ServerChunkCache chunkCache = level.getChunkSource();
            ChunkPos chunkPos = new ChunkPos(lootrSavedData.getInfoPos());
            if (!chunkCache.hasChunk(chunkPos.x, chunkPos.z) || !LoadedChunks.getLoadedChunks((ResourceKey<Level>)lootrSavedData.getInfoDimension()).contains(chunkPos)) continue;
            ILootrInfoProvider provider = null;
            if (lootrSavedData.isEntity()) {
                entity = level.getEntity(lootrSavedData.getInfoUUID());
                if (entity instanceof ILootrEntity) {
                    ILootrEntity cart = (ILootrEntity)entity;
                    provider = cart;
                }
            } else {
                entity = level.getBlockEntity(lootrSavedData.getInfoPos());
                ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(entity);
                if (iLootrBlockEntity instanceof ILootrBlockEntity) {
                    ILootrBlockEntity blockEntity = iLootrBlockEntity;
                    provider = blockEntity;
                }
            }
            if (provider == null) continue;
            provider.removeVisualOpener(id);
            provider.performClose();
            provider.performUpdate();
        }
        if (count > 0) {
            data.save();
            LootrAPI.LOG.info("Cleared {} inventories for player UUID {}", (Object)count, (Object)id.toString());
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static int cullInventories() {
        DimensionDataStorage data = DataStorage.getDataStorage();
        if (data == null) {
            return 0;
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return 0;
        }
        Set<String> files = DataStorage.getAllLootrFiles();
        HashSet<String> filesToDelete = new HashSet<String>();
        for (String file : files) {
            SavedData datum = data.get(new SavedData.Factory(() -> LootrDummyData.INSTANCE, LootrSavedData::load, null), file);
            if (datum == LootrDummyData.INSTANCE) {
                LootrAPI.LOG.error("Failed to load data for {}, removing from cache.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            if (!(datum instanceof LootrSavedData)) {
                LootrAPI.LOG.error("Data for {} is not a LootrSavedData instance.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            LootrSavedData lootrSavedData = (LootrSavedData)datum;
            if (!lootrSavedData.canBeCulled()) continue;
            filesToDelete.add(file);
            ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
        }
        if (!filesToDelete.isEmpty()) {
            IOUtil.cullSavedDataAsync(server, filesToDelete);
            LootrAPI.LOG.info("Culling {} inventories.", (Object)filesToDelete.size());
        }
        return filesToDelete.size();
    }

    private static class LootrDummyData
    extends SavedData {
        public static final LootrDummyData INSTANCE = new LootrDummyData();

        public CompoundTag save(CompoundTag p_77763_, HolderLookup.Provider p_323640_) {
            return null;
        }
    }
}

