package noobanidus.mods.lootr.neoforge.gen;

import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;

public class LootrLangProvider extends LanguageProvider {
  public LootrLangProvider(PackOutput output) {
    super(output, LootrAPI.MODID, "en_us");
  }

  @Override
  protected void addTranslations() {
    // Tag translations
    add("lootr.commands.usage", "/lootr cart | cart <loot-table> | %s | custom-chest | custom-area <x> <y> <z> <x> <y> <z> | refresh | decay | open_as <player> | open_as_uuid <uuid> | id | openers | clear <player> | cclear <entity matcher>");

    add("lootr.message.should_sneak", "Breaking this block will prevent others from obtaining loot! Only break if really needed.");
    add("lootr.message.cart_should_sneak", "Destroying this entity will prevent others from obtaining loot! Only destroy if really needed.");

    add("lootr.message.should_sneak2", "To break the block anyway, sneak while breaking.");
    add("lootr.message.cart_should_sneak2", "To destroy this entity anyway, sneak while attacking.");

    add("lootr.message.cannot_break", "Lootr blocks and entities cannot be broken or destroyed.");
    add("lootr.message.cannot_break_sneak", "While in creative mode, you must sneak to break or destroy Lootr blocks and entities.");

    add("lootr.message.decayed", "The decaying container crumbles at your touch!");
    add("lootr.message.decay_in", "This container will decay completely in %s seconds.");
    add("lootr.message.decay_start", "The container begins to crumble at your touch! It will decay completely in %s seconds.");

    add("lootr.message.refreshed", "The contents of the container are refreshed at your touch!");
    add("lootr.message.refresh_in", "This container will refresh its contents in %s seconds.");
    add("lootr.message.refresh_start", "The container will refresh with new contents in %s seconds!");

    add("lootr.message.invalid_table", "Error with mod [%s], not Lootr! The loot table for this container [%s] does not exist or could not be loaded. Please report this to the mod author, not to Lootr.");

    add(LootrRegistry.getChestBlock(), "Loot Chest");
    add(LootrRegistry.getTrappedChestBlock(), "Loot Chest");
    add(LootrRegistry.getBarrelBlock(), "Loot Barrel");
    add(LootrRegistry.getShulkerBlock(), "Loot Shulker");
    add(LootrRegistry.getInventoryBlock(), "Loot Chest");
    add(LootrRegistry.getMinecart(), "Minecart with Loot Chest");
    add(LootrRegistry.getTrophyBlock(), "Centennial Trophy");
    add(LootrRegistry.getSuspiciousGravelBlock(), "Gravel");
    add(LootrRegistry.getSuspiciousSandBlock(), "Sand");
    add(LootrRegistry.getDecoratedPotBlock(), "Decorated Loot Pot");
    add(LootrRegistry.getItemFrame(), "Item Frame with Loot");

    add("stat.lootr.looted_stat", "Containers and entities looted");

    add("lootr.commands.create", "Created a Lootr %s at %s using the loot table %s.");
    add("lootr.commands.summon", "Summoned a Lootr Cart at %s using the loot table %s.");
    add("lootr.commands.blockpos", "%s,%s,%s");

    add("lootr.advancements.100loot.title", "Centennial");
    add("lootr.advancements.100loot.description", "Open 100 Lootr containers!");
    add("lootr.advancements.50loot.title", "Half-Century");
    add("lootr.advancements.50loot.description", "Open 50 Lootr containers!");
    add("lootr.advancements.25loot.title", "Close Quarters");
    add("lootr.advancements.25loot.description", "Open 25 Lootr containers!");
    add("lootr.advancements.10loot.title", "Delightful Decade");
    add("lootr.advancements.10loot.description", "Open 10 Lootr containers!");
    add("lootr.advancements.1chest.title", "'X' Marks the Spot");
    add("lootr.advancements.1chest.description", "Open your first Lootr chest!");
    add("lootr.advancements.1barrel.title", "Barrel Booty");
    add("lootr.advancements.1barrel.description", "Open your first Lootr barrel!");
    add("lootr.advancements.1cart.title", "Tunnel Treasures");
    add("lootr.advancements.1cart.description", "Open your first Lootr minecart!");
    add("lootr.advancements.1shulker.title", "Bounty Box");
    add("lootr.advancements.1shulker.description", "Open your first Lootr shulker box!");
    add("lootr.advancements.1frame.title", "I was framed!");
    add("lootr.advancements.1frame.description", "Loot an item from a Lootr item frame!");
    add("lootr.advancements.social.title", "Socialised Loot");
    add("lootr.advancements.social.description", "Open one of every Lootr container type!");
    add("lootr.advancements.root.title", "Belongs in a Museum");
    add("lootr.advancements.root.description", "Bring instanced, per-player loot to your world.");
    add("lootr.advancements.all_gravel.title", "Brush It Off");
    add("lootr.advancements.all_gravel.description", "Brush all types of suspicious Lootr blocks!");
    add("lootr.advancements.a_pot.title", "Woe to the Pot");
    add("lootr.advancements.a_pot.description", "Loot your first Lootr decorated pot!");
    add("lootr.advancements.archaeologist.title", "That Was 90% Gravity");
    add("lootr.advancements.archaeologist.description", "Loot all of Lootr's archaeological blocks!");

    add("itemGroup.lootr", "Lootr");
    // Should be fixed hopefully
    add("itemGroup.lootr.lootr", "Lootr");
    add("text.autoconfig.lootr.title", "Lootr");

    // Config
    var debug = "Debug";
    var report_invalid_tables = "Report Invalid Tables";
    var seed = "Seed";
    var randomize_seed = "Randomize Seed";
    var conversion = "Conversion";
    var max_entry_age = "Maximum Block Entity Age";
    var disable = "Disable Conversion";
    var elytra = "Convert Elytra Item Frames";
    var elytra_chests = "Convert Elytra Item Frames into Chests";
    var elytra_frame = "Convert Elytra Item Frames into Lootr Item Frames";
    var frames = "Convert Structure Item Frames";
    var mode = "Container Data Save Mode";
    var spawn = "Bypass Spawn Protection";
    var convert_mineshafts = "Convert Mineshaft Chest Carts";
    var world_border = "Disable Conversion Outside World Border";
    var breaking = "Breaking";
    var enable_break = "Enable All Breaking";
    var enable_fake_player_break = "Enable Fake Player Breaking";
    var disable_break = "Disable Break";
    var power_comparators = "Power Comparators";
    var blast_resistant = "Blast Resistance";
    var blast_immune = "Blast Immunity";
    var should_drop_player_loot = "Broken Containers Drop Player's Loot";
    var trapped_custom = "Custom Inventories Are Trapped";
    var lists = "Lists";
    var dimension_whitelist = "Dimension Whitelist";
    var dimension_blacklist = "Dimension Blacklist";
    var dimension_modid_whitelist = "Dimension Modid Whitelist";
    var dimension_modid_blacklist = "Dimension Modid Blacklist";
    var loot_table_blacklist = "Loot Table Blacklist";
    var loot_modid_blacklist = "Loot ModID Blacklist";
    var decay = "Decay";
    var decay_value = "Decay Value";
    var decay_all = "Decay All";
    var decay_modids = "Decay ModIDs";
    var decay_loot_tables = "Decay Loot Tables";
    var decay_dimensions = "Decay Dimensions";
    var replace_when_decayed = "Replace When Decayed";
    var refresh = "Refresh";
    var refresh_value = "Refresh Value";
    var refresh_all = "Refresh All";
    var refresh_modids = "Refresh ModIDs";
    var refresh_loot_tables = "Refresh Loot Tables";
    var refresh_dimensions = "Refresh Dimensions";
    var notifications = "Notifications";
    var notification_delay = "Delay";
    var disable_notifications = "Disable Notifications";
    var disable_message_styles = "Disable Style And Formatting In Notifications";
    var client = "Client";
    var vanilla_textures = "Vanilla Textures";
    var old_textures = "Classic Textures";
    var new_textures = "New Textures";
    var report_unresolved_tables = "Report Unresolved Loot Tables to Players";
    var perform_tick_decay = "Perform Decay While Ticking";
    var start_tick_decay = "Start Decay While Ticking";
    var perform_tick_refresh = "Perform Refresh While Ticking";
    var start_tick_refresh = "Start Refresh While Ticking";
    var rename_container_block_entities = "Rename Container Block Entities";
    var perform_piecewise_check = "Perform Piecewise Check";
    var skip_logging = "Skip Logging LootTable-less Block Entities during Generation";
    var brushables = "Lootr Brushable Blocks Don't Fall";
    var supported = "Lootr Item Frames Don't Break";
    add("text.autoconfig.lootr.option.debug", debug);
    add("text.autoconfig.lootr.option.debug.report_invalid_tables", report_invalid_tables);
    add("text.autoconfig.lootr.option.seed", seed);
    add("text.autoconfig.lootr.option.seed.randomize_seed", randomize_seed);
    add("text.autoconfig.lootr.option.conversion", conversion);
    add("text.autoconfig.lootr.option.conversion.max_entry_age", max_entry_age);
    add("text.autoconfig.lootr.option.conversion.disable", disable);
    add("text.autoconfig.lootr.option.conversion.convert_elytras", elytra);
    add("text.autoconfig.lootr.option.conversion.bypass_spawn_protection", spawn);
    add("text.autoconfig.lootr.option.conversion.world_border", world_border);
    add("text.autoconfig.lootr.option.conversion.skip_logging_no_loot_table_at_generation", skip_logging);
    add("text.autoconfig.lootr.option.conversion.save_mode", mode);
    add("text.autoconfig.lootr.option.conversion.convert_structure_item_frames", frames);
    add("text.autoconfig.lootr.option.conversion.convert_elytras_to_chests", elytra_chests);
    add("text.autoconfig.lootr.option.conversion.convert_elytras_to_item_frames", elytra_frame);
    add("text.autoconfig.lootr.option.breaking", breaking);
    add("text.autoconfig.lootr.option.breaking.enable_break", enable_break);
    add("text.autoconfig.lootr.option.breaking.enable_fake_player_break", enable_fake_player_break);
    add("text.autoconfig.lootr.option.breaking.disable_break", disable_break);
    add("text.autoconfig.lootr.option.breaking.power_comparators", power_comparators);
    add("text.autoconfig.lootr.option.breaking.blast_resistant", blast_resistant);
    add("text.autoconfig.lootr.option.breaking.blast_immune", blast_immune);
    add("text.autoconfig.lootr.option.breaking.trapped_custom", trapped_custom);
    add("text.autoconfig.lootr.option.breaking.should_drop_player_loot", should_drop_player_loot);
    add("text.autoconfig.lootr.option.breaking.brushables_self_support", brushables);
    add("text.autoconfig.lootr.option.breaking.item_frames_self_support", supported);
    add("text.autoconfig.lootr.option.lists", lists);
    add("text.autoconfig.lootr.option.lists.dimension_whitelist", dimension_whitelist);
    add("text.autoconfig.lootr.option.lists.dimension_blacklist", dimension_blacklist);
    add("text.autoconfig.lootr.option.lists.modid_dimension_whitelist", dimension_modid_whitelist);
    add("text.autoconfig.lootr.option.lists.modid_dimension_blacklist", dimension_modid_blacklist);
    add("text.autoconfig.lootr.option.lists.loot_table_blacklist", loot_table_blacklist);
    add("text.autoconfig.lootr.option.lists.loot_modid_blacklist", loot_modid_blacklist);
    add("text.autoconfig.lootr.option.decay", decay);
    add("text.autoconfig.lootr.option.decay.decay_value", decay_value);
    add("text.autoconfig.lootr.option.decay.decay_all", decay_all);
    add("text.autoconfig.lootr.option.decay.decay_modids", decay_modids);
    add("text.autoconfig.lootr.option.decay.decay_loot_tables", decay_loot_tables);
    add("text.autoconfig.lootr.option.decay.decay_dimensions", decay_dimensions);
    add("text.autoconfig.lootr.option.decay.replace_when_decayed", replace_when_decayed);
    add("text.autoconfig.lootr.option.refresh", refresh);
    add("text.autoconfig.lootr.option.refresh.refresh_value", refresh_value);
    add("text.autoconfig.lootr.option.refresh.refresh_all", refresh_all);
    add("text.autoconfig.lootr.option.refresh.refresh_modids", refresh_modids);
    add("text.autoconfig.lootr.option.refresh.refresh_loot_tables", refresh_loot_tables);
    add("text.autoconfig.lootr.option.refresh.refresh_dimensions", refresh_dimensions);
    add("text.autoconfig.lootr.option.notifications", notifications);
    add("text.autoconfig.lootr.option.notifications.notification_delay", notification_delay);
    add("text.autoconfig.lootr.option.notifications.disable_notifications", disable_notifications);
    add("text.autoconfig.lootr.option.notifications.disable_message_styles", disable_message_styles);
    add("text.autoconfig.lootr.option.client", client);
    add("text.autoconfig.lootr.option.client.vanilla_textures", vanilla_textures);
    add("text.autoconfig.lootr.option.client.old_textures", old_textures);
    add("text.autoconfig.lootr.option.client.new_textures", new_textures);
    add("text.autoconfig.lootr.option.debug.report_unresolved_tables", report_unresolved_tables);
    add("text.autoconfig.lootr.option.conversion.convert_mineshafts", convert_mineshafts);
    add("text.autoconfig.lootr.option.decay.perform_tick_decay", perform_tick_decay);
    add("text.autoconfig.lootr.option.decay.start_tick_decay", start_tick_decay);
    add("text.autoconfig.lootr.option.refresh.perform_tick_refresh", perform_tick_refresh);
    add("text.autoconfig.lootr.option.refresh.start_tick_refresh", start_tick_refresh);
    add("text.autoconfig.lootr.option.conversion.rename_container_block_entities", rename_container_block_entities);
    add("text.autoconfig.lootr.option.conversion.perform_piecewise_check", perform_piecewise_check);
    add("lootr.configuration.conversion", conversion);
    add("lootr.configuration.refresh", refresh);
    add("lootr.configuration.breaking", breaking);
    add("lootr.configuration.problematic_loot_tables", "Problematic Loot Tables");
    var redstone = "Redstone Power";
    add("lootr.configuration.power", redstone);
    add("lootr.configuration.notifications", notifications);
    add("lootr.configuration.decay", decay);
    add("lootr.configuration.whitelist", lists);
    add("lootr.configuration.randomise_seed", randomize_seed);
    add("lootr.configuration.max_age", max_entry_age);
    add("lootr.configuration.disable", disable);
    add("lootr.configuration.convert_mineshafts", convert_mineshafts);
    add("lootr.configuration.convert_elytras", elytra);
    add("lootr.configuration.bypass_spawn_protection", spawn);
    add("lootr.configuration.report_unresolved_tables", report_unresolved_tables);
    add("lootr.configuration.check_world_border", world_border);
    add("lootr.configuration.perform_piecewise_check", perform_piecewise_check);
    add("lootr.configuration.dimension_whitelist", dimension_whitelist);
    add("lootr.configuration.dimension_blacklist", dimension_blacklist);
    add("lootr.configuration.modid_dimension_whitelist", dimension_modid_whitelist);
    add("lootr.configuration.modid_dimension_blacklist", dimension_modid_blacklist);
    add("lootr.configuration.loot_table_blacklist", loot_table_blacklist);
    add("lootr.configuration.loot_modid_blacklist", loot_modid_blacklist);
    add("lootr.configuration.disable_break", disable_break);
    add("lootr.configuration.enable_break", enable_break);
    add("lootr.configuration.enable_fake_player_break", enable_fake_player_break);
    add("lootr.configuration.blast_resistant", blast_resistant);
    add("lootr.configuration.blast_immune", blast_immune);
    add("lootr.configuration.should_drop_player_loot", should_drop_player_loot);
    add("lootr.configuration.power_comparators", power_comparators);
    add("lootr.configuration.trapped_custom", trapped_custom);
    add("lootr.configuration.disable_notifications", disable_notifications);
    add("lootr.configuration.disable_message_styles", disable_message_styles);
    add("lootr.configuration.notification_delay", notification_delay);
    add("lootr.configuration.decay_value", decay_value);
    add("lootr.configuration.decay_all", decay_all);
    add("lootr.configuration.decay_modids", decay_modids);
    add("lootr.configuration.decay_loot_tables", decay_loot_tables);
    add("lootr.configuration.decay_dimensions", decay_dimensions);
    add("lootr.configuration.perform_decay_while_ticking", perform_tick_decay);
    add("lootr.configuration.start_decay_while_ticking", start_tick_decay);
    add("lootr.configuration.refresh_value", refresh_value);
    add("lootr.configuration.refresh_all", refresh_all);
    add("lootr.configuration.refresh_modids", refresh_modids);
    add("lootr.configuration.refresh_loot_tables", refresh_loot_tables);
    add("lootr.configuration.refresh_dimensions", refresh_dimensions);
    add("lootr.configuration.start_refresh_while_ticking", start_tick_refresh);
    add("lootr.configuration.perform_refresh_while_ticking", perform_tick_refresh);
    add("lootr.configuration.textures", "Client Textures");
    add("lootr.configuration.vanilla_textures", vanilla_textures);
    add("lootr.configuration.new_textures", old_textures);
    add("lootr.configuration.replace_when_decayed", replace_when_decayed);
    add("lootr.configuration.skip_logging_no_loot_table_at_generation", skip_logging);
    add("lootr.configuration.save_mode", mode);
    add("lootr.configuration.convert_item_frames", frames);
    add("lootr.configuration.convert_elytras_to_chests", elytra_chests);
    add("lootr.configuration.convert_elytras_to_item_frames", elytra_frame);
    add("lootr.configuration.brushables_self_support", brushables);
    add("lootr.configuration.item_frames_self_support", supported);

    // Tags
    add(LootrTags.Blocks.CONVERT_BARRELS, "Blocks that Convert to Lootr Barrels");
    add(LootrTags.Blocks.CONVERT_CHESTS, "Blocks that Convert to Lootr Chests");
    add(LootrTags.Blocks.CONVERT_SHULKERS, "Blocks that Convert to Lootr Shulkers");
    add(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS, "Blocks that Convert to Trapped Lootr Chests");
    add(LootrTags.Blocks.CONVERT_POTS, "Blocks that Convert to Lootr Pots");
    add(LootrTags.Blocks.CONVERT_GRAVELS, "Blocks that Convert to Suspicious Lootr Gravels");
    add(LootrTags.Blocks.CONVERT_SANDS, "Blocks that Convert to Suspicious Lootr Sands");
    add(LootrTags.Blocks.CONVERT_BLOCK, "All Blocks that Convert to Lootr Containers");
    add(LootrTags.Blocks.CONVERT_BLACKLIST, "Blocks that are blocked from being converted to Lootr Containers");

    add(LootrTags.Blocks.CONTAINERS, "Lootr Containers");
    add(LootrTags.Blocks.CHESTS, "Lootr Chests");
    add(LootrTags.Blocks.BARRELS, "Lootr Barrels");
    add(LootrTags.Blocks.SHULKERS, "Lootr Shulkers");
    add(LootrTags.Blocks.TRAPPED_CHESTS, "Trapped Lootr Chests");
    add(LootrTags.Blocks.SANDS, "Suspicious Lootr Sands");
    add(LootrTags.Blocks.GRAVELS, "Suspicious Lootr Gravels");
    add(LootrTags.Blocks.POTS, "Lootr Pots");
    add(LootrTags.Blocks.CUSTOM_ELIGIBLE, "Custom Inventory Eligible Target Blocks");
    add(LootrTags.Blocks.CATS_CAN_BLOCK, "Blocks Cats Can Sit On");
    add(LootrTags.Blocks.NON_BLOCKING, "Blocks That Do Not Prevent Opening Chests");
    add(LootrTags.Blocks.INTERACT_WHITELIST_BLOCKS, "Blocks That Bypass Spawn Protection Interaction Disabling");

    add(LootrTags.Items.CONTAINERS, "Lootr Containers");
    add(LootrTags.Items.CHESTS, "Lootr Chests");
    add(LootrTags.Items.BARRELS, "Lootr Barrels");
    add(LootrTags.Items.SHULKERS, "Lootr Shulkers");
    add(LootrTags.Items.TRAPPED_CHESTS, "Trapped Lootr Chests");
    add(LootrTags.Items.SANDS, "Suspicious Lootr Sands");
    add(LootrTags.Items.GRAVELS, "Suspicious Lootr Gravels");
    add(LootrTags.Items.POTS, "Lootr Pots");
    add(LootrTags.Items.ITEM_FRAME_CONVERT_BLACKLIST, "Item Frame Item Blacklist");

    add(LootrTags.Entity.CONTAINERS, "Lootr Containers");
    add(LootrTags.Entity.CONVERT_ENTITIES, "Entities that Convert to Lootr Containers");
    add(LootrTags.Entity.CONVERT_BLACKLIST, "Entities that Do Not Convert to Lootr Containers");
    add(LootrTags.Entity.CONVERT_CARTS, "Minecarts that can convert to Lootr carts");
    add(LootrTags.Entity.ITEM_FRAMES, "Lootr Item Frames");
    add(LootrTags.Entity.MINECARTS, "Lootr Minecarts");
  }
}
