/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import org.jetbrains.annotations.Nullable;

public class AdapterMap {
    private static final ILootrDataAdapter<Object> NONE = new ILootrDataAdapter<Object>(){

        @Override
        public Class<Object> getAssignableClass() {
            return Object.class;
        }

        @Override
        @Nullable
        public ResourceKey<LootTable> getLootTable(Object entity) {
            return null;
        }

        @Override
        public long getLootSeed(Object entity) {
            return 0L;
        }

        @Override
        public void setLootTable(Object entity, ResourceKey<LootTable> table, long seed) {
        }

        @Override
        public int priority() {
            return Integer.MIN_VALUE;
        }
    };
    private final Map<Class<?>, ILootrDataAdapter<?>> byClass = new ConcurrentHashMap();
    private final List<ILootrDataAdapter<?>> allAdapters = new ArrayList();

    public <T> void register(ILootrDataAdapter<T> adapter) {
        this.allAdapters.add(adapter);
        this.byClass.clear();
    }

    @Nullable
    public <T> ILootrDataAdapter<T> getAdapter(T type) {
        if (type == null) {
            return null;
        }
        Class<?> clazz = type.getClass();
        ILootrDataAdapter potentialAdapter = this.byClass.computeIfAbsent(clazz, clazz2 -> {
            ILootrDataAdapter<?> best = null;
            int bestDistance = Integer.MAX_VALUE;
            int bestPriority = Integer.MIN_VALUE;
            for (ILootrDataAdapter<?> adapter : this.allAdapters) {
                if (!adapter.getAssignableClass().isAssignableFrom((Class<?>)clazz2)) continue;
                int d = AdapterMap.distance(clazz2, adapter);
                int p = adapter.priority();
                if (d >= bestDistance && (d != bestDistance || p <= bestPriority)) continue;
                best = adapter;
                bestDistance = d;
                bestPriority = p;
            }
            return best == null ? NONE : best;
        });
        if (potentialAdapter == NONE) {
            return null;
        }
        return potentialAdapter;
    }

    private static int distance(Class<?> runtime, ILootrDataAdapter<?> target) {
        Class<?> targetClass = target.getAssignableClass();
        int d = 0;
        for (Class<?> c = runtime; c != null; c = c.getSuperclass()) {
            if (c == targetClass) {
                return d;
            }
            ++d;
        }
        return Integer.MAX_VALUE;
    }
}

