/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.IClientOpeners;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.CustomLootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.blockentity.RandomizableContainerBlockEntityLootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.entity.AbstractMinecartContainerLootrInfoProvider;
import org.jetbrains.annotations.Nullable;

public interface ILootrInfoProvider
extends ILootrInfo,
IClientOpeners {
    public static ILootrInfoProvider of(BlockPos pos, Level level) {
        if (level.isClientSide()) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return null;
    }

    public static ILootrInfoProvider of(RandomizableContainerBlockEntity blockEntity, UUID id) {
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return new RandomizableContainerBlockEntityLootrInfoProvider(blockEntity, id, ILootrInfo.generateInfoKey(id), null);
    }

    public static ILootrInfoProvider of(RandomizableContainerBlockEntity blockEntity, UUID id, NonNullList<ItemStack> customInventory) {
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return new RandomizableContainerBlockEntityLootrInfoProvider(blockEntity, id, ILootrInfo.generateInfoKey(id), customInventory);
    }

    public static ILootrInfoProvider of(AbstractMinecartContainer minecart) {
        if (minecart instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)minecart;
            return provider;
        }
        return new AbstractMinecartContainerLootrInfoProvider(minecart, ILootrInfo.generateInfoKey(minecart.getUUID()));
    }

    @Deprecated
    public static ILootrInfoProvider of(UUID id, BlockPos pos, int containerSize, ResourceKey<LootTable> lootTable, long lootSeed, Component displayName, ResourceKey<Level> dimension, NonNullList<ItemStack> customInventory, @Deprecated ILootrInfo.LootrInfoType type, @Deprecated LootrBlockType blockType) {
        return new CustomLootrInfoProvider(id, ILootrInfo.generateInfoKey(id), pos, containerSize, lootTable, lootSeed, displayName, dimension, customInventory, type, blockType, null);
    }

    public static ILootrInfoProvider of(UUID id, BlockPos pos, int containerSize, ResourceKey<LootTable> lootTable, long lootSeed, Component displayName, ResourceKey<Level> dimension, NonNullList<ItemStack> customInventory, ILootrType type) {
        return new CustomLootrInfoProvider(id, ILootrInfo.generateInfoKey(id), pos, containerSize, lootTable, lootSeed, displayName, dimension, customInventory, null, null, type);
    }

    default public int getPhysicalOpenerCount() {
        return -1;
    }

    @Override
    default public Set<UUID> getVisualOpeners() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            return data.getVisualOpeners();
        }
        return null;
    }

    @Override
    default public Set<UUID> getActualOpeners() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            return data.getActualOpeners();
        }
        return null;
    }

    @Nullable
    default public IContainerTrigger getTrigger() {
        return null;
    }

    default public void performTrigger(ServerPlayer player) {
        IContainerTrigger trigger = this.getTrigger();
        if (trigger != null && !this.hasServerOpened((Player)player)) {
            trigger.trigger(player, this.getInfoUUID());
        }
    }

    default public void performOpen(ServerPlayer player) {
    }

    default public void performOpen() {
    }

    default public void performClose(ServerPlayer player) {
    }

    default public void performClose() {
    }

    default public void performDecay() {
    }

    default public void performRefresh() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            data.refresh();
            data.clearOpeners();
            this.markChanged();
        }
    }

    default public void performUpdate(ServerPlayer player) {
    }

    default public void performUpdate() {
    }

    @Override
    default public void markDataChanged() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            data.markChanged();
        }
    }
}

