/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import org.jetbrains.annotations.Nullable;

public class AdapterMap {
    private final Map<Class<?>, ILootrDataAdapter<?>> byClass = new ConcurrentHashMap();
    private final List<ILootrDataAdapter<?>> allAdapters = new ArrayList();
    private final Set<Class<?>> noAdapter = ConcurrentHashMap.newKeySet();

    public <T> void register(ILootrDataAdapter<T> adapter) {
        Class<T> clazz = adapter.getAssignableClass();
        for (ILootrDataAdapter<?> otherAdapter : this.allAdapters) {
            Class<T> otherClazz = otherAdapter.getAssignableClass();
            if (!clazz.isAssignableFrom(otherClazz) && !otherClazz.isAssignableFrom(clazz)) continue;
            throw new IllegalArgumentException("Adapter class '" + String.valueOf(clazz) + "' conflicts with already existing class '" + String.valueOf(otherClazz) + "'");
        }
        this.allAdapters.add(adapter);
        this.byClass.clear();
        this.noAdapter.clear();
    }

    @Nullable
    public <T> ILootrDataAdapter<T> getAdapter(T type) {
        if (type == null) {
            return null;
        }
        Class<?> clazz = type.getClass();
        if (this.noAdapter.contains(clazz)) {
            return null;
        }
        ILootrDataAdapter potentialAdapter = this.byClass.computeIfAbsent(clazz, clazz2 -> {
            for (ILootrDataAdapter<?> adapter : this.allAdapters) {
                if (!adapter.getAssignableClass().isAssignableFrom((Class<?>)clazz2)) continue;
                return adapter;
            }
            return null;
        });
        if (potentialAdapter == null) {
            this.noAdapter.add(clazz);
            return null;
        }
        return potentialAdapter;
    }
}

