/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBlock;
import org.jetbrains.annotations.Nullable;

public class ClientHooks {
    @Nullable
    public static Player getPlayer() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return null;
        }
        return mc.player;
    }

    public static void clearCache(BlockPos position) {
        SectionPos pos = SectionPos.of((BlockPos)position);
        Minecraft.getInstance().submit(() -> Minecraft.getInstance().levelRenderer.setSectionDirty(pos.x(), pos.y(), pos.z()));
    }

    public static void refreshSection() {
        Player player = ClientHooks.getPlayer();
        if (player != null) {
            ClientHooks.clearCache(player.blockPosition());
        }
    }

    public static void performBreakEffect(int entityId, BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        Entity entity = mc.level.getEntity(entityId);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player == mc.player) {
            BlockState state = mc.level.getBlockState(pos);
            ((AccessorMixinBlock)state.getBlock()).lootr$spawnDestroyParticles((Level)mc.level, player, pos, state);
            mc.level.playSound(null, pos, SoundEvents.DECORATED_POT_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            mc.level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 7; ++i) {
                mc.level.addParticle((ParticleOptions)ParticleTypes.DUST_PLUME, false, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }
}

