/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.event;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;

@EventBusSubscriber(modid="lootr")
public class HandleCart {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return;
        }
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)level.dimension()) || LootrAPI.isDisabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.getType().is(LootrTags.Entity.CONVERT_ENTITIES)) {
            ILootrDataAdapter<Entity> adapter = LootrAPI.getAdapter(entity);
            if (adapter == null) {
                LootrAPI.LOG.error("No adapter found for entity '{}' even though it is tagged for conversion.", (Object)entity);
                return;
            }
            ResourceKey<LootTable> lootTable = adapter.getLootTable(entity);
            if (lootTable == null || LootrAPI.isLootTableBlacklisted(lootTable)) {
                return;
            }
            long seed = adapter.getLootSeed(entity);
            LootrAPI.preProcess(level, entity, lootTable, seed);
            LootrChestMinecartEntity lootrCart = new LootrChestMinecartEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ());
            PlatformAPI.copyEntityData(adapter, entity, lootrCart);
            event.setCanceled(true);
            LootrAPI.postProcess(level, (Entity)lootrCart, lootTable, seed);
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            executor.tell((Runnable)new TickTask(0, () -> event.getLevel().addFreshEntity((Entity)lootrCart)));
        }
    }
}

