/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.block.LootrBarrelBlock;
import noobanidus.mods.lootr.common.block.LootrChestBlock;
import noobanidus.mods.lootr.common.block.LootrShulkerBlock;
import noobanidus.mods.lootr.common.block.entity.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.data.LootrInventory;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBaseContainerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class CommandLootr {
    private static List<ResourceKey<LootTable>> tables = null;
    private static List<String> tableNames = null;
    private CommandDispatcher<CommandSourceStack> dispatcher;

    public CommandLootr(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.dispatcher = dispatcher;
    }

    private static List<ResourceKey<LootTable>> getTables() {
        if (tables == null) {
            tables = new ArrayList<ResourceKey<LootTable>>(BuiltInLootTables.all());
            tableNames = tables.stream().map(o -> o.location().toString()).toList();
        }
        return tables;
    }

    private static List<String> getProfiles() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            return Collections.emptyList();
        }
        GameProfileCache cache = server.getProfileCache();
        if (cache == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(cache.profilesByName.keySet());
    }

    private static List<String> getTableNames() {
        CommandLootr.getTables();
        return tableNames;
    }

    public static void createBlock(CommandSourceStack c, @Nullable Block block, @Nullable ResourceKey<LootTable> incomingTable) {
        ServerLevel world = c.getLevel();
        Vec3 incomingPos = c.getPosition();
        BlockPos pos = new BlockPos((int)incomingPos.x, (int)incomingPos.y, (int)incomingPos.z);
        ResourceKey<LootTable> table = incomingTable == null ? CommandLootr.getTables().get(world.getRandom().nextInt(CommandLootr.getTables().size())) : incomingTable;
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            Entity e = c.getEntity();
            if (e != null) {
                cart.setYRot(e.getYRot());
            }
            cart.setLootTable(table, world.getRandom().nextLong());
            world.addFreshEntity((Entity)cart);
            c.sendSuccess(() -> Component.translatable((String)"lootr.commands.summon", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN)).withBold(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            BlockState placementState = block.defaultBlockState();
            Entity e = c.getEntity();
            if (e != null) {
                DirectionProperty prop = null;
                Direction dir = Direction.orderedByNearest((Entity)e)[0].getOpposite();
                if (placementState.hasProperty((Property)LootrBarrelBlock.FACING)) {
                    prop = LootrBarrelBlock.FACING;
                } else if (placementState.hasProperty((Property)LootrChestBlock.FACING)) {
                    prop = LootrChestBlock.FACING;
                    dir = e.getDirection().getOpposite();
                } else if (placementState.hasProperty((Property)LootrShulkerBlock.FACING)) {
                    prop = LootrShulkerBlock.FACING;
                }
                if (prop != null) {
                    placementState = (BlockState)placementState.setValue((Property)prop, (Comparable)dir);
                }
            }
            world.setBlock(pos, placementState, 2);
            ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(world.getBlockEntity(pos));
            if (iLootrBlockEntity instanceof ILootrBlockEntity) {
                ILootrBlockEntity randomizableBe = iLootrBlockEntity;
                randomizableBe.setLootTableInternal(table, world.getRandom().nextLong());
            }
            c.sendSuccess(() -> Component.translatable((String)"lootr.commands.create", (Object[])new Object[]{Component.translatable((String)block.getDescriptionId()), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN)).withBold(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    private static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.withSize((int)reference.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).copy());
        }
        return contents;
    }

    public CommandLootr register() {
        this.dispatcher.register(this.builder((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"lootr").requires(p -> p.hasPermission(2)))));
        this.dispatcher = null;
        return this;
    }

    private RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> suggestTables() {
        return Commands.argument((String)"table", (ArgumentType)ResourceLocationArgument.id()).suggests((c, build) -> SharedSuggestionProvider.suggest(CommandLootr.getTableNames(), (SuggestionsBuilder)build));
    }

    private RequiredArgumentBuilder<CommandSourceStack, String> suggestProfiles() {
        return Commands.argument((String)"profile", (ArgumentType)StringArgumentType.string()).suggests((c, build) -> SharedSuggestionProvider.suggest(CommandLootr.getProfiles(), (SuggestionsBuilder)build));
    }

    public LiteralArgumentBuilder<CommandSourceStack> builder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.translatable((String)"lootr.commands.usage"), false);
            return 1;
        });
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"pot").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getDecoratedPotBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getDecoratedPotBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"gravel").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getSuspiciousGravelBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getSuspiciousGravelBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"sand").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getSuspiciousSandBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getSuspiciousSandBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"barrel").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getBarrelBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getBarrelBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"trapped_chest").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getTrappedChestBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getTrappedChestBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"chest").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getChestBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getChestBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"shulker").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getShulkerBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), LootrRegistry.getShulkerBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Must provide player name."), true);
            return 1;
        })).then(this.suggestProfiles().executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((CommandSourceStack)c.getSource()).getServer().getProfileCache().get(playerName);
            if (!opt_profile.isPresent()) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            GameProfile profile = (GameProfile)opt_profile.get();
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)(LootrAPI.clearPlayerLoot(profile.getId()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear")), true);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"cart").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocationArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(Commands.literal((String)"custom").executes(c -> {
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockState state = level.getBlockState(pos);
            if (!state.is(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                pos = pos.below();
                state = level.getBlockState(pos);
            }
            if (!state.is(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on the container you wish to convert."), false);
            } else {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof BaseContainerBlockEntity) {
                    BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
                } else {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on the container you wish to convert."), false);
                }
                NonNullList<ItemStack> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                BlockState newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().defaultBlockState());
                NonNullList<ItemStack> custom = CommandLootr.copyItemList(reference);
                level.removeBlockEntity(pos);
                level.setBlockAndUpdate(pos, newState);
                BlockEntity te = level.getBlockEntity(pos);
                if (!(te instanceof LootrInventoryBlockEntity)) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.setChanged();
                }
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"open_as").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Must provide player name."), true);
            return 1;
        })).then(this.suggestProfiles().executes(c -> {
            ILootrBlockEntity ibe;
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((CommandSourceStack)c.getSource()).getServer().getProfileCache().get(playerName);
            if (!opt_profile.isPresent()) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            GameProfile profile = (GameProfile)opt_profile.get();
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity te = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                te = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            if (data == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"No Lootr data found for this container."), false);
                return 0;
            }
            LootrInventory inventory = data.getInventory(profile.getId());
            if (inventory == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("No stored inventory for " + playerName + " found.")), true);
                return 0;
            }
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayer();
            if (player == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.openMenu((MenuProvider)inventory);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"open_as_uuid").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Must provide player UUID."), true);
            return 1;
        })).then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(c -> {
            ILootrBlockEntity ibe;
            UUID id;
            String uuid = StringArgumentType.getString((CommandContext)c, (String)"uuid");
            try {
                id = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException exception) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Invalid UUID: " + uuid)));
                return 0;
            }
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity te = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                te = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            LootrInventory inventory = data.getInventory(id);
            if (inventory == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("No stored inventory for " + String.valueOf(id) + " found.")), true);
                return 0;
            }
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayer();
            if (player == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.openMenu((MenuProvider)inventory);
            return 1;
        })));
        builder.then(Commands.literal((String)"id").executes(c -> {
            ILootrBlockEntity ibe;
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel world = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity te = world.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                te = world.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"The ID of this inventory is: ").append((Component)ComponentUtils.copyOnClickText((String)ibe.getInfoUUID().toString())), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"refresh").executes(c -> {
            ILootrBlockEntity ibe;
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                be = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setRefreshing(ibe);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to refresh with a delay of " + LootrAPI.getRefreshValue())), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"decay").executes(c -> {
            ILootrBlockEntity ibe;
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                be = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setDecaying(ibe);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to decay with a delay of " + LootrAPI.getDecayValue())), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"openers").then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(c -> {
            BlockPos position = Vec3Argument.getCoordinates((CommandContext)c, (String)"location").getBlockPos((CommandSourceStack)c.getSource());
            ServerLevel world = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity blockEntity = world.getBlockEntity(position);
            ILootrBlockEntity ibe = LootrAPI.resolveBlockEntity(blockEntity);
            if (ibe != null) {
                Set<UUID> openers = ibe.getActualOpeners();
                if (openers != null) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("BlockEntity at location " + String.valueOf(position) + " has " + openers.size() + " openers. UUIDs as follows:")), true);
                    for (UUID uuid : openers) {
                        Optional prof = ((CommandSourceStack)c.getSource()).getServer().getProfileCache().get(uuid);
                        ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("UUID: " + String.valueOf(uuid) + ", user profile: " + (prof.isPresent() ? ((GameProfile)prof.get()).getName() : "null"))), true);
                    }
                }
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("No Lootr block entity exists at location: " + String.valueOf(position))), false);
            }
            return 1;
        })));
        builder.then(Commands.literal((String)"convert").then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BoundingBox bounds = BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"to"));
            ChunkPos start = new ChunkPos(new BlockPos(bounds.minX(), bounds.minY(), bounds.minZ()));
            ChunkPos stop = new ChunkPos(new BlockPos(bounds.maxX(), bounds.maxY(), bounds.maxZ()));
            ArrayList<ChunkPos> positions = new ArrayList<ChunkPos>();
            for (int x = start.x; x <= stop.x; ++x) {
                for (int z = start.z; z <= stop.z; ++z) {
                    positions.add(new ChunkPos(x, z));
                }
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            for (ChunkPos chunkPos : positions) {
                LevelChunk chunk = level.getChunk(chunkPos.x, chunkPos.z);
                ArrayList<BlockPos> convertableBlocks = new ArrayList<BlockPos>();
                for (BlockPos pos : chunk.getBlockEntitiesPos()) {
                    if (!bounds.isInside((Vec3i)pos)) continue;
                    convertableBlocks.add(pos);
                }
                if (convertableBlocks.isEmpty()) continue;
                for (BlockPos pos : convertableBlocks) {
                    BlockState state;
                    RandomizableContainerBlockEntity lootContainer;
                    BlockEntity blockEntity = chunk.getBlockEntity(pos, LevelChunk.EntityCreationType.IMMEDIATE);
                    if (!(blockEntity instanceof BaseContainerBlockEntity) || blockEntity instanceof RandomizableContainerBlockEntity && (lootContainer = (RandomizableContainerBlockEntity)blockEntity).getLootTable() != null || (state = blockEntity.getBlockState()).is(LootrTags.Blocks.CUSTOM_ELIGIBLE) || blockEntity.getType().builtInRegistryHolder().is(LootrTags.BlockEntity.CUSTOM_INELIGIBlE)) continue;
                    NonNullList<ItemStack> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                    BlockState newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().defaultBlockState());
                    NonNullList<ItemStack> custom = CommandLootr.copyItemList(reference);
                    level.removeBlockEntity(pos);
                    level.setBlockAndUpdate(pos, newState);
                    BlockEntity te = level.getBlockEntity(pos);
                    if (!(te instanceof LootrInventoryBlockEntity)) {
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                        continue;
                    }
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.setChanged();
                }
            }
            return 1;
        }))));
        builder.then(Commands.literal((String)"cclear").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).executes(c -> {
            Collection entities = EntityArgument.getEntities((CommandContext)c, (String)"entities");
            for (Entity e : entities) {
                if (!(e instanceof Player)) continue;
                Player player = (Player)e;
                String name = player.getScoreboardName();
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)(DataStorage.clearInventories(player.getUUID()) ? "Cleared stored inventories for " + name : "No stored inventories for " + name + " to clear")), true);
            }
            return 1;
        })));
        return builder;
    }

    private static BlockState updateBlockState(BlockState oldState, BlockState newState) {
        if (oldState.hasProperty((Property)BlockStateProperties.FACING) && newState.hasProperty((Property)BlockStateProperties.FACING)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)oldState.getValue((Property)BlockStateProperties.FACING)));
        }
        if (oldState.hasProperty((Property)HorizontalDirectionalBlock.FACING) && newState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)oldState.getValue((Property)HorizontalDirectionalBlock.FACING)));
        }
        if (oldState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && newState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.WATERLOGGED)));
        }
        return newState;
    }
}

