/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import noobanidus.mods.lootr.common.api.ILootrAPI;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.MenuBuilder;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.filter.ILootrFilter;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.client.ClientHooks;
import noobanidus.mods.lootr.common.config.Replacements;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.impl.LootrServiceRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultLootrAPIImpl
implements ILootrAPI {
    private static final BoundingBox DESERT_PYRAMID_ADDITIONAL = new BoundingBox(-5, -30, -5, 5, 4, 4);

    @Override
    public final void handleProviderSneak(@Nullable ILootrInfoProvider provider, ServerPlayer player) {
        if (provider == null) {
            return;
        }
        if (provider.removeVisualOpener((Player)player)) {
            provider.performClose(player);
            provider.performUpdate(player);
        }
    }

    @Override
    public final void handleProviderOpen(@Nullable ILootrInfoProvider provider, ServerPlayer player) {
        int refreshValue;
        BaseContainerBlockEntity baseContainer;
        if (provider == null) {
            return;
        }
        if (player.isSpectator()) {
            player.openMenu(null);
            return;
        }
        if (provider.getInfoUUID() == null) {
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.invalid_block").setStyle(LootrAPI.getInvalidStyle()), true);
            return;
        }
        if (provider instanceof BaseContainerBlockEntity && !(baseContainer = (BaseContainerBlockEntity)provider).canOpen((Player)player)) {
            return;
        }
        if (LootrAPI.isDecayed(provider)) {
            provider.performDecay();
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.decayed").setStyle(LootrAPI.getDecayStyle()), true);
            LootrAPI.removeDecayed(provider);
            return;
        }
        int decayValue = LootrAPI.getRemainingDecayValue(provider);
        if (decayValue > 0 && LootrAPI.shouldNotify(decayValue)) {
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).setStyle(LootrAPI.getDecayStyle()), true);
        } else if (decayValue == -1 && LootrAPI.isDecaying(provider)) {
            LootrAPI.setDecaying(provider);
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.decay_start", (Object[])new Object[]{LootrAPI.getDecayValue() / 20}).setStyle(LootrAPI.getDecayStyle()), true);
        }
        provider.performTrigger(player);
        boolean shouldUpdate = false;
        if (LootrAPI.isRefreshed(provider)) {
            provider.performRefresh();
            provider.performClose();
            LootrAPI.removeRefreshed(provider);
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refreshed").setStyle(LootrAPI.getRefreshStyle()), true);
            shouldUpdate = true;
        }
        if ((refreshValue = LootrAPI.getRemainingRefreshValue(provider)) > 0 && LootrAPI.shouldNotify(refreshValue)) {
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).setStyle(LootrAPI.getRefreshStyle()), true);
        } else if (refreshValue == -1 && LootrAPI.isRefreshing(provider)) {
            LootrAPI.setRefreshing(provider);
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refresh_start", (Object[])new Object[]{LootrAPI.getRefreshValue() / 20}).setStyle(LootrAPI.getRefreshStyle()), true);
        }
        ILootrInventory menuProvider = LootrAPI.getInventory(provider, player, DefaultLootFiller.getInstance());
        if (menuProvider == null) {
            return;
        }
        if (!provider.hasOpened((Player)player)) {
            player.awardStat(LootrRegistry.getLootedStat());
            LootrRegistry.getStatTrigger().trigger(player);
        }
        if (provider.addOpener((Player)player)) {
            provider.performOpen(player);
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            provider.performUpdate(player);
        }
        player.openMenu((MenuProvider)menuProvider);
        PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
    }

    @Override
    public final void handleProviderTick(@Nullable ILootrInfoProvider provider) {
        int refreshValue;
        int decayValue;
        if (provider == null) {
            return;
        }
        if (provider.getInfoUUID() == null) {
            return;
        }
        if (LootrAPI.shouldPerformDecayWhileTicking() && LootrAPI.isDecayed(provider) && provider.hasBeenOpened()) {
            provider.performDecay();
            LootrAPI.removeDecayed(provider);
            return;
        }
        if (LootrAPI.shouldStartDecayWhileTicking() && !LootrAPI.isDecayed(provider) && provider.hasBeenOpened() && (decayValue = LootrAPI.getRemainingDecayValue(provider)) == -1 && LootrAPI.isDecaying(provider)) {
            LootrAPI.setDecaying(provider);
        }
        if (LootrAPI.shouldPerformRefreshWhileTicking() && LootrAPI.isRefreshed(provider) && provider.hasBeenOpened()) {
            provider.performRefresh();
            provider.performClose();
            LootrAPI.removeRefreshed(provider);
            provider.performUpdate();
        }
        if (LootrAPI.shouldStartRefreshWhileTicking() && !LootrAPI.isRefreshed(provider) && provider.hasBeenOpened() && (refreshValue = LootrAPI.getRemainingRefreshValue(provider)) == -1 && LootrAPI.isRefreshing(provider)) {
            LootrAPI.setRefreshing(provider);
        }
    }

    @Override
    public final Set<UUID> getPlayerIds() {
        MinecraftServer server = this.getServer();
        if (server == null) {
            return Set.of();
        }
        HashSet<UUID> result = new HashSet<UUID>();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            UUID thisUuid;
            if (this.isFakePlayer((Player)player) || (thisUuid = player.getUUID()) == null) continue;
            result.add(thisUuid);
        }
        return result;
    }

    @Override
    public final boolean clearPlayerLoot(UUID id) {
        return DataStorage.clearInventories(id);
    }

    @Override
    public final ILootrInventory getInventory(ILootrInfoProvider provider, ServerPlayer player, LootFiller filler) {
        return DataStorage.getInventory(provider, player, filler);
    }

    @Override
    public final ILootrInventory getInventory(ILootrInfoProvider provider, ServerPlayer player, LootFiller filler, MenuBuilder menuBuilder) {
        ILootrInventory inventory = DataStorage.getInventory(provider, player, filler);
        if (inventory != null) {
            inventory.setMenuBuilder(menuBuilder);
        }
        return inventory;
    }

    @Override
    @Nullable
    public final ILootrSavedData getData(ILootrInfoProvider provider) {
        return DataStorage.getData(provider);
    }

    @Override
    public final boolean shouldDiscard() {
        return LootrAPI.shouldDiscardIdAndOpeners;
    }

    @Override
    public final boolean isAwarded(UUID uuid, ServerPlayer player) {
        return DataStorage.isAwarded(uuid, player);
    }

    @Override
    @Deprecated
    public final void award(UUID id, ServerPlayer player) {
        DataStorage.award(id, player);
    }

    @Override
    public final int getRemainingDecayValue(ILootrInfoProvider provider) {
        return DataStorage.getDecayValue(provider);
    }

    @Override
    public final boolean isDecayed(ILootrInfoProvider provider) {
        return DataStorage.isDecayed(provider);
    }

    @Override
    public final void setDecaying(ILootrInfoProvider provider) {
        DataStorage.setDecaying(provider);
    }

    @Override
    public final void removeDecayed(ILootrInfoProvider provider) {
        DataStorage.removeDecayed(provider);
    }

    @Override
    public final int getRemainingRefreshValue(ILootrInfoProvider provider) {
        return DataStorage.getRefreshValue(provider);
    }

    @Override
    public final boolean isRefreshed(ILootrInfoProvider provider) {
        return DataStorage.isRefreshed(provider);
    }

    @Override
    public final void setRefreshing(ILootrInfoProvider provider) {
        DataStorage.setRefreshing(provider);
    }

    @Override
    public final void removeRefreshed(ILootrInfoProvider provider) {
        DataStorage.removeRefreshed(provider);
    }

    @Override
    @Nullable
    public final <T extends BlockEntity> ILootrBlockEntity resolveBlockEntity(T blockEntity) {
        return LootrServiceRegistry.convertBlockEntity(blockEntity);
    }

    @Override
    public final <T extends Entity> ILootrCart resolveEntity(T entity) {
        return LootrServiceRegistry.convertEntity(entity);
    }

    @Override
    public boolean isTaggedStructurePresent(ServerLevel level, ChunkPos chunkPos, TagKey<Structure> tag, BlockPos pos) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        List starts = level.structureManager().startsForStructure(chunkPos, o -> registry.getHolder(registry.getId(o)).map(b -> b.is(tag)).orElse(false));
        for (StructureStart start : starts) {
            BlockPos center;
            BoundingBox extended = start.getBoundingBox().inflatedBy(8);
            if (extended.isInside((Vec3i)pos)) {
                return true;
            }
            if (!start.getStructure().type().equals((Object)StructureType.DESERT_PYRAMID) || !DESERT_PYRAMID_ADDITIONAL.moved((center = start.getBoundingBox().getCenter()).getX(), center.getY(), center.getZ()).isInside((Vec3i)pos)) continue;
            return true;
        }
        if (LootrAPI.performPiecewiseCheck()) {
            for (StructureStart start : starts) {
                for (StructurePiece piece : start.getPieces()) {
                    if (!piece.getBoundingBox().inflatedBy(8).isInside((Vec3i)pos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isWorldBorderSafe(Level level, BlockPos pos) {
        if (!this.shouldCheckWorldBorder()) {
            return true;
        }
        return level.getWorldBorder().isWithinBounds(pos);
    }

    @Override
    public boolean isWorldBorderSafe(Level level, ChunkPos pos) {
        if (!this.shouldCheckWorldBorder()) {
            return true;
        }
        return level.getWorldBorder().isWithinBounds(pos);
    }

    @Override
    public void playerDestroyed(Level level, Player player, BlockPos pos, @Nullable BlockEntity blockEntity) {
        if (!this.shouldDropPlayerLoot() || level.isClientSide() || blockEntity == null) {
            return;
        }
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ServerPlayer serverPlayer;
            ILootrInventory inventory;
            ILootrBlockEntity provider = iLootrBlockEntity;
            if (player instanceof ServerPlayer && (inventory = this.getInventory(provider, serverPlayer = (ServerPlayer)player, DefaultLootFiller.getInstance())) != null) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)inventory);
            }
        }
    }

    @Override
    public void refreshSections() {
        MinecraftServer server = this.getServer();
        if (server == null || server.isSingleplayer() || !server.isDedicatedServer()) {
            ClientHooks.refreshSection();
        }
    }

    @Override
    @Nullable
    public BlockState replacementBlockState(BlockState original) {
        return Replacements.replacement(original);
    }

    @Override
    public List<ILootrFilter> getFilters() {
        return LootrServiceRegistry.getFilters();
    }
}

