/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.data.LootrInventory;
import org.jetbrains.annotations.Nullable;

public class LootrSavedData
extends class_18
implements ILootrSavedData {
    public static final Codec<LootrSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("hasBeenOpened").forGetter(LootrSavedData::hasBeenOpened), (App)ILootrInfo.CODEC.fieldOf("info").forGetter(data -> data.info), (App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), ILootrInventory.CODEC).fieldOf("inventories").forGetter(data -> data.inventories), (App)class_4844.field_48974.fieldOf("openers").forGetter(data -> data.openers), (App)class_4844.field_48974.fieldOf("actualOpeners").forGetter(data -> data.actualOpeners)).apply((Applicative)instance, LootrSavedData::new));
    private boolean hasBeenOpened;
    private ILootrInfo info;
    private final Map<UUID, LootrInventory> inventories = new HashMap<UUID, LootrInventory>();
    private final Set<UUID> openers = new ObjectLinkedOpenHashSet();
    private final Set<UUID> actualOpeners = new ObjectLinkedOpenHashSet();

    protected LootrSavedData(ILootrInfo info) {
        this(info, false);
    }

    protected LootrSavedData(ILootrInfo info, boolean noCopy) {
        this.info = noCopy ? info : BaseLootrInfo.copy(info);
    }

    private LootrSavedData(boolean hasBeenOpened, ILootrInfo info, Map<UUID, LootrInventory> map, Set<UUID> openers, Set<UUID> actualOpeners) {
        this.hasBeenOpened = hasBeenOpened;
        this.info = info;
        this.inventories.putAll(map);
        for (LootrInventory inv : this.inventories.values()) {
            inv.setLootrSavedData(this);
        }
        this.openers.addAll(openers);
        this.actualOpeners.addAll(actualOpeners);
    }

    public static Supplier<LootrSavedData> fromInfo(ILootrInfo info) {
        return () -> new LootrSavedData(info);
    }

    @Override
    public ILootrInfo getRedirect() {
        return this.info;
    }

    @Override
    public Set<UUID> getVisualOpeners() {
        return this.openers;
    }

    @Override
    public boolean addVisualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.addVisualOpener(uuid);
        if (result) {
            this.method_80();
        }
        return result;
    }

    @Override
    public boolean removeVisualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.removeVisualOpener(uuid);
        if (result) {
            this.method_80();
        }
        return result;
    }

    @Override
    public boolean addActualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.addActualOpener(uuid);
        if (result) {
            this.method_80();
        }
        return result;
    }

    private void removeOpener(UUID uuid) {
        Set<UUID> visualOpeners = this.getVisualOpeners();
        if (visualOpeners != null && visualOpeners.remove(uuid)) {
            this.method_80();
        }
    }

    @Override
    public Set<UUID> getActualOpeners() {
        return this.actualOpeners;
    }

    @Override
    public void markChanged() {
        this.method_80();
    }

    @Override
    public void markDataChanged() {
        this.markChanged();
    }

    @Override
    @Nullable
    public LootrInventory getInventory(UUID id) {
        LootrInventory inventory = this.inventories.get(id);
        if (inventory != null) {
            inventory.setInfo(this);
        }
        return inventory;
    }

    @Override
    public LootrInventory createInventory(ILootrInfoProvider provider, class_3222 player, LootFiller filler) {
        LootrInventory result = new LootrInventory(provider.buildInitialInventory());
        result.setLootrSavedData(this);
        if (!LootrAPI.isFakePlayer((class_1657)player)) {
            filler.unpackLootTable(provider, (class_1657)player, result);
        }
        this.inventories.put(player.method_5667(), result);
        this.hasBeenOpened = true;
        this.method_80();
        return result;
    }

    @Override
    public void update(ILootrInfo info) {
        BaseLootrInfo infoCopy = BaseLootrInfo.copy(info);
        if (!infoCopy.equals(this.info)) {
            this.markChanged();
            this.info = info;
        }
    }

    @Override
    public void refresh() {
        this.inventories.clear();
        this.hasBeenOpened = false;
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return false;
    }

    @Override
    public boolean clearInventories(UUID id) {
        if (this.inventories.remove(id) != null) {
            this.removeOpener(id);
            this.method_80();
            return true;
        }
        return false;
    }
}

