/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import noobanidus.mods.lootr.common.api.LootrAPI;

public class ConfigManagerBase {
    protected static Set<String> validateStringList(Collection<? extends String> incomingList, String listKey) {
        HashSet<String> validatedList = new HashSet<String>();
        for (String string : incomingList) {
            if (string == null || string.isEmpty()) {
                LootrAPI.LOG.error("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a String.");
                continue;
            }
            validatedList.add(string);
        }
        return validatedList;
    }

    protected static Set<class_5321<class_1937>> validateDimensions(Collection<? extends String> incomingList, String listKey) {
        return ConfigManagerBase.validateResourceKeyList(incomingList, listKey, o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)o));
    }

    protected static <T> Set<class_5321<T>> validateResourceKeyList(Collection<? extends String> incomingList, String listKey, Function<class_2960, class_5321<T>> builder) {
        HashSet<class_5321<T>> validatedList = new HashSet<class_5321<T>>();
        for (String string : incomingList) {
            class_2960 location;
            if (string == null || string.isEmpty()) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a ResourceLocation.");
            }
            try {
                location = class_2960.method_60654((String)string);
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + string + "', is not a valid ResourceLocation.", e);
            }
            try {
                validatedList.add(builder.apply(location));
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + string + "', is not valid to create a ResourceKey.", e);
            }
        }
        return validatedList;
    }
}

