/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1693;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import noobanidus.mods.lootr.common.api.IClientOpeners;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.CustomLootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.blockentity.RandomizableContainerBlockEntityLootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.entity.AbstractMinecartContainerLootrInfoProvider;
import org.jetbrains.annotations.Nullable;

public interface ILootrInfoProvider
extends ILootrInfo,
IClientOpeners {
    public static ILootrInfoProvider of(class_2338 pos, class_1937 level) {
        if (level.method_8608()) {
            return null;
        }
        class_2586 blockEntity = level.method_8321(pos);
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return null;
    }

    public static ILootrInfoProvider of(class_2621 blockEntity, UUID id) {
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return new RandomizableContainerBlockEntityLootrInfoProvider(blockEntity, id, ILootrInfo.generateInfoKey(id), null);
    }

    public static ILootrInfoProvider of(class_2621 blockEntity, UUID id, class_2371<class_1799> customInventory) {
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return new RandomizableContainerBlockEntityLootrInfoProvider(blockEntity, id, ILootrInfo.generateInfoKey(id), customInventory);
    }

    public static ILootrInfoProvider of(class_1693 minecart) {
        if (minecart instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)minecart;
            return provider;
        }
        return new AbstractMinecartContainerLootrInfoProvider(minecart, ILootrInfo.generateInfoKey(minecart.method_5667()));
    }

    public static ILootrInfoProvider of(UUID id, class_2338 pos, int containerSize, class_5321<class_52> lootTable, long lootSeed, class_2561 displayName, class_5321<class_1937> dimension, class_2371<class_1799> customInventory, ILootrInfo.LootrInfoType type, LootrBlockType blockType) {
        return new CustomLootrInfoProvider(id, ILootrInfo.generateInfoKey(id), pos, containerSize, lootTable, lootSeed, displayName, dimension, customInventory, type, blockType);
    }

    default public int getPhysicalOpenerCount() {
        return -1;
    }

    @Override
    default public Set<UUID> getVisualOpeners() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            return data.getVisualOpeners();
        }
        return null;
    }

    @Override
    default public Set<UUID> getActualOpeners() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            return data.getActualOpeners();
        }
        return null;
    }

    @Nullable
    default public IContainerTrigger getTrigger() {
        return null;
    }

    default public void performTrigger(class_3222 player) {
        IContainerTrigger trigger = this.getTrigger();
        if (trigger != null) {
            trigger.trigger(player, this.getInfoUUID());
        }
    }

    default public void performOpen(class_3222 player) {
    }

    default public void performOpen() {
    }

    default public void performClose(class_3222 player) {
    }

    default public void performClose() {
    }

    default public void performDecay() {
    }

    default public void performRefresh() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            data.refresh();
            data.clearOpeners();
            this.markChanged();
        }
    }

    default public void performUpdate(class_3222 player) {
    }

    default public void performUpdate() {
    }

    @Override
    default public void markDataChanged() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            data.markChanged();
        }
    }
}

