/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3708;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LootrBarrelBlockEntity
extends class_2621
implements ILootrBlockEntity {
    private final class_2371<class_1799> items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private final Set<UUID> clientOpeners = new ObjectLinkedOpenHashSet();
    protected UUID infoId = null;
    protected boolean hasBeenOpened = false;
    private String cachedId;
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 level, class_2338 pos, class_2680 state) {
            if (!LootrBarrelBlockEntity.this.hasBeenOpened) {
                LootrBarrelBlockEntity.this.hasBeenOpened = true;
                LootrBarrelBlockEntity.this.markChanged();
            }
            LootrBarrelBlockEntity.this.playSound(state, class_3417.field_17604);
            LootrBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 state) {
            LootrBarrelBlockEntity.this.playSound(state, class_3417.field_17603);
            LootrBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 state, int p_155069_, int p_155070_) {
        }

        protected boolean method_31679(class_1657 player) {
            class_1707 chestMenu;
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof class_1707 && (class_17032 = (chestMenu = (class_1707)class_17032).method_7629()) instanceof ILootrInventory) {
                ILootrInventory data = (ILootrInventory)class_17032;
                return data.getInfo().getInfoUUID().equals(LootrBarrelBlockEntity.this.getInfoUUID());
            }
            return false;
        }
    };
    protected boolean clientOpened = false;

    public LootrBarrelBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(LootrRegistry.getBarrelBlockEntity(), pWorldPosition, pBlockState);
    }

    @Override
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.BARREL;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return this.method_11010().method_28498((class_2769)class_3708.field_18006) && (Boolean)this.method_11010().method_11654((class_2769)class_3708.field_18006) != false;
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> pItems) {
    }

    public void method_54873(@Nullable class_1657 player) {
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11014(compound, provider);
        this.method_54871(compound);
        if (compound.method_25928("LootrId")) {
            this.infoId = compound.method_25926("LootrId");
        }
        if (compound.method_10573("LootrHasBeenOpened", 1)) {
            this.hasBeenOpened = compound.method_10577("LootrHasBeenOpened");
        }
        if (this.infoId == null) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        if (compound.method_10545("LootrOpeners")) {
            class_2499 list = compound.method_10554("LootrOpeners", 11);
            for (class_2520 thisTag : list) {
                this.clientOpeners.add(class_2512.method_25930((class_2520)thisTag));
            }
        }
    }

    public void method_57569(class_2487 compoundTag) {
        super.method_57569(compoundTag);
        compoundTag.method_10551("LootrId");
    }

    protected void method_11007(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11007(compound, provider);
        this.method_54872(compound);
        if (!LootrAPI.shouldDiscard()) {
            compound.method_25927("LootrId", this.getInfoUUID());
        }
        compound.method_10556("LootrHasBeenOpened", this.hasBeenOpened);
        if (this.field_11863 != null && this.field_11863.method_8608() && this.clientOpeners != null && !this.clientOpeners.isEmpty()) {
            class_2499 list = new class_2499();
            for (UUID opener : this.clientOpeners) {
                list.add((Object)class_2512.method_25929((UUID)opener));
            }
            compound.method_10566("LootrOpeners", (class_2520)list);
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.barrel");
    }

    protected class_1703 method_5465(int pContainerId, class_1661 pInventory) {
        return null;
    }

    public int method_5439() {
        return 27;
    }

    public void method_5435(class_1657 pPlayer) {
        if (!this.field_11865 && !pPlayer.method_7325()) {
            this.openersCounter.method_31684(pPlayer, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 pPlayer) {
        if (!this.field_11865 && !pPlayer.method_7325()) {
            this.openersCounter.method_31685(pPlayer, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void recheckOpen() {
        if (!this.field_11865) {
            this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    protected void updateBlockState(class_2680 pState, boolean pOpen) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)pState.method_11657((class_2769)class_3708.field_18006, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    protected void playSound(class_2680 pState, class_3414 pSound) {
        class_2382 vec3i = ((class_2350)pState.method_11654((class_2769)class_3708.field_16320)).method_62675();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, pSound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    @Override
    public void markChanged() {
        this.method_5431();
        this.markDataChanged();
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    @Override
    public boolean isClientOpened() {
        return this.clientOpened;
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 result = super.method_16887(provider);
        this.method_11007(result, provider);
        Set currentOpeners = this.getVisualOpeners();
        if (currentOpeners != null && !currentOpeners.isEmpty()) {
            class_2499 list = new class_2499();
            for (UUID opener : Sets.intersection((Set)currentOpeners, LootrAPI.getPlayerIds())) {
                list.add((Object)class_2512.method_25929((UUID)opener));
            }
            if (!list.isEmpty()) {
                result.method_10566("LootrOpeners", (class_2520)list);
            }
        }
        return result;
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    @Override
    @NotNull
    public class_2338 getInfoPos() {
        return this.method_11016();
    }

    @Override
    public class_5321<class_52> getInfoLootTable() {
        return this.method_54869();
    }

    @Override
    @Nullable
    public class_2561 getInfoDisplayName() {
        return this.method_5476();
    }

    @Override
    @NotNull
    public class_5321<class_1937> getInfoDimension() {
        return this.method_10997().method_27983();
    }

    @Override
    public int getInfoContainerSize() {
        return this.method_5439();
    }

    @Override
    public long getInfoLootSeed() {
        return this.method_54870();
    }

    @Override
    @Nullable
    public class_2371<class_1799> getInfoReferenceInventory() {
        return null;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Override
    public class_1937 getInfoLevel() {
        return this.method_10997();
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        return LootrRegistry.getBarrelTrigger();
    }

    @Override
    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    @Override
    public int getPhysicalOpenerCount() {
        return this.openersCounter.method_31678();
    }

    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrBarrelBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrBarrelBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public class_2591<?> getBlockEntityType() {
            return LootrRegistry.getBarrelBlockEntity();
        }
    }
}

