/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.event;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.block.entity.BlockEntityTicker;
import noobanidus.mods.lootr.common.command.CommandLootr;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.entity.EntityTicker;
import noobanidus.mods.lootr.fabric.event.HandleBreak;
import noobanidus.mods.lootr.fabric.event.HandleChunk;

public class LootrEventsInit {
    public static MinecraftServer serverInstance;
    public static CommandLootr lootrCommand;

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            serverInstance = server;
            HandleChunk.onServerStarted();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            serverInstance = null;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            DataStorage.doTick();
            BlockEntityTicker.onServerTick();
            EntityTicker.onServerTick();
        });
        ServerChunkEvents.CHUNK_LOAD.register(HandleChunk::onChunkLoad);
        PlayerBlockBreakEvents.BEFORE.register(HandleBreak::beforeBlockBreak);
        PlayerBlockBreakEvents.CANCELED.register(HandleBreak::afterBlockBreak);
        CommandRegistrationCallback.EVENT.register((dispatcher, reg, env) -> {
            lootrCommand = new CommandLootr((CommandDispatcher<CommandSourceStack>)dispatcher);
            lootrCommand.register();
        });
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("lootr").orElseThrow();
        ResourceManagerHelper.registerBuiltinResourcePack((Identifier)LootrAPI.rl("old_textures"), (ModContainer)container, (Component)Component.literal((String)"Lootr - Old Textures"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
    }
}

