/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.event;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.block.entity.BlockEntityTicker;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import noobanidus.mods.lootr.common.command.CommandLootr;
import noobanidus.mods.lootr.fabric.event.HandleBreak;

public class LootrEventsInit {
    public static MinecraftServer serverInstance;

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            serverInstance = server;
            LoadedChunks.clear();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            serverInstance = null;
            LoadedChunks.clear();
        });
        ServerTickEvents.END_SERVER_TICK.register(BlockEntityTicker::onServerTick);
        ServerChunkEvents.CHUNK_LOAD.register(LoadedChunks::onChunkLoad);
        ServerChunkEvents.CHUNK_UNLOAD.register(LoadedChunks::onChunkUnload);
        PlayerBlockBreakEvents.BEFORE.register(HandleBreak::beforeBlockBreak);
        PlayerBlockBreakEvents.CANCELED.register(HandleBreak::afterBlockBreak);
        CommandRegistrationCallback.EVENT.register((dispatcher, reg, env) -> CommandLootr.register((CommandDispatcher<CommandSourceStack>)dispatcher));
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("lootr").orElseThrow();
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)LootrAPI.rl("old_textures"), (ModContainer)container, (Component)Component.literal((String)"Lootr - Old Textures"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        LootrEventsInit.registerPack(container, "lootr_no_advancements", (Component)Component.literal((String)"Disable Lootr Advancements"));
        LootrEventsInit.registerPack(container, "lootr_no_suspicious_blocks", (Component)Component.literal((String)"Disable Lootr Converting Suspicious Blocks"));
    }

    private static void registerPack(ModContainer container, String name, Component desc) {
        ResourceManagerHelperImpl.registerBuiltinResourcePack((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)container.getMetadata().getId(), (String)name), (String)("datapacks/" + name), (ModContainer)container, (Component)desc, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
    }
}

