/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.TickingData;

public class NewTickingData {
    private static final Function<String, SavedData.Factory<Section>> STRING_FACTORY = name -> new SavedData.Factory(() -> new Section((String)name), Section::load, null);
    private static final Object2ObjectMap<UUID, String> CACHED_NAMES = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<UUID, String> CACHED_FILE_NAMES = new Object2ObjectOpenHashMap();
    private final String prefix;
    private final TickingType type;
    private static final Object2ObjectMap<TickingType, NewTickingData> INSTANCES = new Object2ObjectOpenHashMap();

    public static NewTickingData getInstance(TickingType type) {
        return (NewTickingData)INSTANCES.get((Object)type);
    }

    public static NewTickingData getRefreshData() {
        return NewTickingData.getInstance(TickingType.REFRESH);
    }

    public static NewTickingData getDecayData() {
        return NewTickingData.getInstance(TickingType.DECAY);
    }

    public void migrateOldData(MinecraftServer server, TickingData oldData) {
        long currentGameTime = server.getWorldData().overworldData().getGameTime();
        for (Object2IntMap.Entry entry : oldData.getTickMap().object2IntEntrySet()) {
            UUID id = (UUID)entry.getKey();
            long completesAt = currentGameTime;
            int oldValue = entry.getIntValue();
            if (oldValue > 0) {
                completesAt += (long)oldValue;
            }
            Section section = this.getSection(server, id);
            try {
                section.setCompletesAt(id, completesAt);
            }
            catch (SectionException e) {
                LootrAPI.LOG.error("Unable to migrate {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
            }
        }
    }

    protected NewTickingData(TickingType type) {
        this.type = type;
        this.prefix = "lootr/ticking/" + type.getPrefix() + "/";
    }

    public boolean isCompleted(MinecraftServer server, UUID id) {
        Section section = this.getSection(server, id);
        try {
            return section.completed(server, id);
        }
        catch (SectionException e) {
            LootrAPI.LOG.error("Unable to check {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
            return false;
        }
    }

    public void setCompletesIn(MinecraftServer server, UUID id, long tickTime) {
        Section section = this.getSection(server, id);
        try {
            section.setCompletesAt(id, server.getWorldData().overworldData().getGameTime() + tickTime);
        }
        catch (SectionException e) {
            LootrAPI.LOG.error("Unable to set {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
        }
    }

    public long howLongUntilComplete(MinecraftServer server, UUID id) {
        Section section = this.getSection(server, id);
        try {
            long completesAt = section.completesAt(id);
            if (completesAt == -1L) {
                return -1L;
            }
            long currentTime = server.getWorldData().overworldData().getGameTime();
            return Math.max(0L, completesAt - currentTime);
        }
        catch (SectionException e) {
            LootrAPI.LOG.error("Unable to get {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
            return -1L;
        }
    }

    private static String getCached(UUID id) {
        return (String)CACHED_NAMES.computeIfAbsent((Object)id, UUID::toString);
    }

    private static String getBaseFileName(UUID id) {
        return (String)CACHED_FILE_NAMES.computeIfAbsent((Object)id, uuid -> {
            String name = NewTickingData.getCached(uuid);
            return name.substring(0, 2);
        });
    }

    private String getFileName(UUID id) {
        return this.prefix + NewTickingData.getBaseFileName(id);
    }

    private Section getSection(MinecraftServer server, UUID id) {
        ServerLevel level = server.overworld();
        DimensionDataStorage dataStorage = level.getDataStorage();
        return (Section)dataStorage.computeIfAbsent(STRING_FACTORY.apply(NewTickingData.getBaseFileName(id)), this.getFileName(id));
    }

    static {
        for (TickingType type : TickingType.values()) {
            INSTANCES.put((Object)type, (Object)new NewTickingData(type));
        }
    }

    public static enum TickingType {
        DECAY("decay"),
        REFRESH("refresh");

        private final String prefix;

        private TickingType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    protected static class Section
    extends SavedData {
        private final Object2LongMap<UUID> tickMap = new Object2LongOpenHashMap();
        private final String cachedName;

        public Section(String cachedName) {
            this.tickMap.defaultReturnValue(-1L);
            this.cachedName = cachedName;
        }

        private boolean excludes(UUID id) {
            return !this.cachedName.equals(NewTickingData.getBaseFileName(id));
        }

        public boolean completed(MinecraftServer server, UUID id) throws SectionException {
            if (this.excludes(id)) {
                throw new SectionException();
            }
            long completesAt = this.completesAt(id);
            if (completesAt == -1L) {
                return false;
            }
            return server.getWorldData().overworldData().getGameTime() >= completesAt;
        }

        public long completesAt(UUID id) throws SectionException {
            if (this.excludes(id)) {
                throw new SectionException();
            }
            return this.tickMap.getLong((Object)id);
        }

        public void setCompletesAt(UUID id, long tickTime) throws SectionException {
            if (this.excludes(id)) {
                throw new SectionException();
            }
            this.tickMap.put((Object)id, tickTime);
            this.setDirty();
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
            ListTag decayList = new ListTag();
            for (Object2LongMap.Entry entry : this.tickMap.object2LongEntrySet()) {
                CompoundTag thisTag = new CompoundTag();
                thisTag.putUUID("id", (UUID)entry.getKey());
                thisTag.putLong("value", entry.getLongValue());
                decayList.add((Object)thisTag);
            }
            tag.put("result", (Tag)decayList);
            tag.putString("cachedName", this.cachedName);
            return tag;
        }

        public static Section load(CompoundTag pCompound, HolderLookup.Provider provider) {
            String cachedName = pCompound.getString("cachedName");
            Section data = new Section(cachedName);
            data.tickMap.clear();
            data.tickMap.defaultReturnValue(-1L);
            ListTag decayList = pCompound.getList("result", 10);
            for (int i = 0; i < decayList.size(); ++i) {
                CompoundTag thisTag = decayList.getCompound(i);
                data.tickMap.put((Object)thisTag.getUUID("id"), thisTag.getLong("value"));
            }
            return data;
        }

        public void save(File file, HolderLookup.Provider registries) {
            if (this.isDirty()) {
                file.getParentFile().mkdirs();
            }
            super.save(file, registries);
        }
    }

    public static class SectionException
    extends Exception {
    }
}

