/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.mixin.ticker;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.block.entity.BlockEntityTicker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RandomizableContainer.class})
public interface MixinRandomizableContainer {
    @Shadow
    public ResourceKey<LootTable> getLootTable();

    @Shadow
    public Level getLevel();

    @WrapOperation(method={"tryLoadLootTable"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/RandomizableContainer;setLootTableSeed(J)V")})
    default public void lootr$tryLoadLootTable(RandomizableContainer instance, long l, Operation<Void> original) {
        original.call(new Object[]{instance, l});
        if (instance.getLevel() != null && !instance.getLevel().isClientSide() && instance instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)instance;
            if (!(instance instanceof ILootrBlockEntity) && !(LootrAPI.resolveBlockEntity(blockEntity) instanceof ILootrBlockEntity)) {
                BlockEntityTicker.addEntity(blockEntity, blockEntity.getLevel(), new ChunkPos(blockEntity.getBlockPos()));
            }
        }
    }

    @WrapOperation(method={"setLootTable(Lnet/minecraft/resources/ResourceKey;J)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/RandomizableContainer;setLootTable(Lnet/minecraft/resources/ResourceKey;)V")})
    default public void lootr$setLootTable(RandomizableContainer instance, ResourceKey<LootTable> table, Operation<Void> original) {
        original.call(new Object[]{instance, table});
        if (table != null && instance.getLevel() != null && !instance.getLevel().isClientSide() && instance instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)instance;
            if (!(instance instanceof ILootrBlockEntity) && !(LootrAPI.resolveBlockEntity(blockEntity) instanceof ILootrBlockEntity)) {
                BlockEntityTicker.addEntity(blockEntity, blockEntity.getLevel(), new ChunkPos(blockEntity.getBlockPos()));
            }
        }
    }

    @Inject(method={"unpackLootTable"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/ReloadableServerRegistries$Holder;getLootTable(Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/world/level/storage/loot/LootTable;")}, cancellable=true)
    default public void lootr$unpackLootTable(Player player, CallbackInfo ci) {
        BlockEntity blockEntity;
        MixinRandomizableContainer mixinRandomizableContainer = this;
        if (mixinRandomizableContainer instanceof BlockEntity && BlockEntityTicker.isValidEntityFull(blockEntity = (BlockEntity)mixinRandomizableContainer)) {
            BlockEntityTicker.addEntity(blockEntity, blockEntity.getLevel(), new ChunkPos(blockEntity.getBlockPos()));
            ci.cancel();
        }
    }
}

