/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.client.block;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import noobanidus.mods.lootr.common.api.LootrAPI;
import org.jetbrains.annotations.Nullable;

public class BarrelModel
implements UnbakedModel {
    private final UnbakedModel opened;
    private final UnbakedModel unopened;
    private final UnbakedModel vanilla;
    private final UnbakedModel old_opened;
    private final UnbakedModel old_unopened;
    private Collection<ResourceLocation> dependencies = null;

    public BarrelModel(UnbakedModel opened, UnbakedModel unopened, UnbakedModel vanilla, UnbakedModel old_opened, UnbakedModel old_unopened) {
        this.opened = opened;
        this.unopened = unopened;
        this.vanilla = vanilla;
        this.old_opened = old_opened;
        this.old_unopened = old_unopened;
    }

    public Collection<ResourceLocation> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = Streams.concat((Stream[])new Stream[]{this.opened.getDependencies().stream(), this.unopened.getDependencies().stream(), this.vanilla.getDependencies().stream(), this.old_opened.getDependencies().stream(), this.old_unopened.getDependencies().stream()}).collect(Collectors.toSet());
        }
        return this.dependencies;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
        this.opened.resolveParents(function);
        this.unopened.resolveParents(function);
        this.vanilla.resolveParents(function);
        this.old_opened.resolveParents(function);
        this.old_unopened.resolveParents(function);
    }

    @Nullable
    public BakedModel bake(ModelBaker modelBakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform) {
        return new BakedBarrelModel(this.opened.bake(modelBakery, spriteGetter, transform), this.unopened.bake(modelBakery, spriteGetter, transform), this.vanilla.bake(modelBakery, spriteGetter, transform), this.old_opened.bake(modelBakery, spriteGetter, transform), this.old_unopened.bake(modelBakery, spriteGetter, transform));
    }

    public static class BakedBarrelModel
    implements BakedModel,
    FabricBakedModel {
        private final BakedModel opened;
        private final BakedModel unopened;
        private final BakedModel vanilla;
        private final BakedModel old_opened;
        private final BakedModel old_unopened;

        public BakedBarrelModel(BakedModel opened, BakedModel unopened, BakedModel vanilla, BakedModel old_opened, BakedModel old_unopened) {
            this.opened = opened;
            this.unopened = unopened;
            this.vanilla = vanilla;
            this.old_opened = old_opened;
            this.old_unopened = old_unopened;
        }

        public boolean isVanillaAdapter() {
            return false;
        }

        public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
            BakedModel model;
            Object data = blockView.getBlockEntityRenderData(pos);
            BakedModel bakedModel = model = LootrAPI.isOldTextures() ? this.old_unopened : this.unopened;
            if (LootrAPI.isVanillaTextures()) {
                model = this.vanilla;
            } else if (data == Boolean.TRUE) {
                BakedModel bakedModel2 = model = LootrAPI.isOldTextures() ? this.old_opened : this.opened;
            }
            if (model != null) {
                QuadEmitter emitter = context.getEmitter();
                Renderer renderer = RendererAccess.INSTANCE.getRenderer();
                if (renderer != null) {
                    RenderMaterial material = renderer.materialById(RenderMaterial.MATERIAL_STANDARD);
                    for (Direction dir : Direction.values()) {
                        for (BakedQuad quad : model.getQuads(state, dir, randomSupplier.get())) {
                            emitter.fromVanilla(quad, material, dir);
                            emitter.emit();
                        }
                    }
                    for (BakedQuad quad : model.getQuads(state, null, randomSupplier.get())) {
                        emitter.fromVanilla(quad, material, null);
                        emitter.emit();
                    }
                }
            }
        }

        public void emitItemQuads(ItemStack stack, Supplier<RandomSource> randomSupplier, RenderContext context) {
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            if (LootrAPI.isVanillaTextures()) {
                return this.vanilla.getQuads(state, side, rand);
            }
            if (LootrAPI.isNewTextures()) {
                return this.unopened.getQuads(state, side, rand);
            }
            return this.old_unopened.getQuads(state, side, rand);
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return true;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.unopened.getParticleIcon();
        }

        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        public ItemOverrides getOverrides() {
            return ItemOverrides.EMPTY;
        }
    }
}

