/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.event;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.block.entity.BlockEntityTicker;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import noobanidus.mods.lootr.common.command.CommandLootr;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.entity.EntityTicker;
import noobanidus.mods.lootr.fabric.event.HandleBreak;

public class LootrEventsInit {
    public static MinecraftServer serverInstance;
    public static CommandLootr lootrCommand;

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            serverInstance = server;
            LoadedChunks.clear();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            serverInstance = null;
            LoadedChunks.clear();
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            DataStorage.doTick();
            BlockEntityTicker.onServerTick(server);
            EntityTicker.onServerTick();
        });
        ServerChunkEvents.CHUNK_LOAD.register(LoadedChunks::onChunkLoad);
        ServerChunkEvents.CHUNK_UNLOAD.register(LoadedChunks::onChunkUnload);
        PlayerBlockBreakEvents.BEFORE.register(HandleBreak::beforeBlockBreak);
        PlayerBlockBreakEvents.CANCELED.register(HandleBreak::afterBlockBreak);
        CommandRegistrationCallback.EVENT.register((dispatcher, reg, env) -> {
            lootrCommand = new CommandLootr((CommandDispatcher<class_2168>)dispatcher);
            lootrCommand.register();
        });
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("lootr").orElseThrow();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)LootrAPI.rl("old_textures"), (ModContainer)container, (class_2561)class_2561.method_43470((String)"Lootr - Old Textures"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
    }
}

