/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.advancement.ITrigger;

public class ContainerTrigger
extends SimpleCriterionTrigger<TriggerInstance>
implements IContainerTrigger {
    @Override
    public void trigger(ServerPlayer player, UUID condition) {
        this.trigger(player, instance -> instance.test(player, condition));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static Criterion<TriggerInstance> looted(ITrigger trigger) {
        return ((ContainerTrigger)trigger.getTrigger()).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty()));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player)).apply((Applicative)codec, TriggerInstance::new));

        public boolean test(ServerPlayer player, UUID container) {
            if (LootrAPI.isAwarded(container, player)) {
                return false;
            }
            LootrAPI.award(container, player);
            return true;
        }
    }
}

