/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class UnopenedParticle
extends TextureSheetParticle {
    public UnopenedParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lifetime = 30;
        this.alpha = 0.8f;
        this.xd = 0.0;
        this.yd = ySpeed;
        this.zd = 0.0;
        this.hasPhysics = false;
        this.quadSize = 0.12f;
        this.friction = 1.0f;
        int c1 = 16438858;
        this.rCol = (float)(c1 >> 16 & 0xFF) / 255.0f;
        this.gCol = (float)(c1 >> 8 & 0xFF) / 255.0f;
        this.bCol = (float)(c1 & 0xFF) / 255.0f;
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0 | super.getLightColor(partialTick) & 0xFF0000;
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            float f = (float)this.age / (float)this.lifetime;
            f *= f;
            this.alpha = Math.max(0.0f, 0.8f - f);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            UnopenedParticle particle = new UnopenedParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

