/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.IMarkChanged;
import noobanidus.mods.lootr.common.api.IOpeners;
import noobanidus.mods.lootr.common.api.IRedirect;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ILootrSavedData
extends IRedirect<ILootrInfo>,
ILootrInfo,
IOpeners,
IMarkChanged {
    public void update(ILootrInfo var1);

    public void refresh();

    default public boolean clearInventories(ServerPlayer player) {
        return this.clearInventories(player.getUUID());
    }

    public boolean clearInventories(UUID var1);

    default public ILootrInventory getInventory(ServerPlayer player) {
        return this.getInventory(player.getUUID());
    }

    default public ILootrInventory getOrCreateInventory(ILootrInfoProvider provider, ServerPlayer player, LootFiller filler) {
        if (provider.canPlayerOpen(player)) {
            ILootrInventory result = this.getInventory(player);
            if (result != null) {
                return result;
            }
            return this.createInventory(provider, player, filler);
        }
        provider.informPlayerCannotOpen(player);
        return null;
    }

    public ILootrInventory getInventory(UUID var1);

    public ILootrInventory createInventory(ILootrInfoProvider var1, ServerPlayer var2, LootFiller var3);

    @Override
    @Deprecated
    @Nullable
    default public ILootrInfo.LootrInfoType getInfoType() {
        return ((ILootrInfo)this.getRedirect()).getInfoType();
    }

    @Override
    @Deprecated
    @Nullable
    default public LootrBlockType getInfoBlockType() {
        return ((ILootrInfo)this.getRedirect()).getInfoBlockType();
    }

    @Override
    @Nullable
    default public ILootrType getInfoNewType() {
        return ((ILootrInfo)this.getRedirect()).getInfoNewType();
    }

    @Override
    @NotNull
    default public Vec3 getInfoVec() {
        return ((ILootrInfo)this.getRedirect()).getInfoVec();
    }

    @Override
    @NotNull
    default public UUID getInfoUUID() {
        return ((ILootrInfo)this.getRedirect()).getInfoUUID();
    }

    @Override
    default public String getInfoKey() {
        return ((ILootrInfo)this.getRedirect()).getInfoKey();
    }

    @Override
    @NotNull
    default public BlockPos getInfoPos() {
        return ((ILootrInfo)this.getRedirect()).getInfoPos();
    }

    @Override
    @Nullable
    default public Component getInfoDisplayName() {
        return ((ILootrInfo)this.getRedirect()).getInfoDisplayName();
    }

    @Override
    @NotNull
    default public ResourceKey<Level> getInfoDimension() {
        return ((ILootrInfo)this.getRedirect()).getInfoDimension();
    }

    @Override
    default public int getInfoContainerSize() {
        return ((ILootrInfo)this.getRedirect()).getInfoContainerSize();
    }

    @Override
    @Nullable
    default public Level getInfoLevel() {
        return ((ILootrInfo)this.getRedirect()).getInfoLevel();
    }

    @Override
    @Nullable
    default public Container getInfoContainer() {
        return ((ILootrInfo)this.getRedirect()).getInfoContainer();
    }

    @Override
    @Nullable
    default public NonNullList<ItemStack> getInfoReferenceInventory() {
        return ((ILootrInfo)this.getRedirect()).getInfoReferenceInventory();
    }

    @Override
    default public boolean isInfoReferenceInventory() {
        return ((ILootrInfo)this.getRedirect()).isInfoReferenceInventory();
    }

    @Override
    default public ResourceKey<LootTable> getInfoLootTable() {
        return ((ILootrInfo)this.getRedirect()).getInfoLootTable();
    }

    @Override
    default public long getInfoLootSeed() {
        return ((ILootrInfo)this.getRedirect()).getInfoLootSeed();
    }
}

