/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.PotDecorationsAdapter;
import noobanidus.mods.lootr.common.api.registry.LootrProperties;
import noobanidus.mods.lootr.common.block.entity.LootrDecoratedPotBlockEntity;
import noobanidus.mods.lootr.common.client.ClientHooks;
import noobanidus.mods.lootr.common.integration.sherdsapi.SherdsIntegration;

public class LootrDecoratedPotRenderer
implements BlockEntityRenderer<LootrDecoratedPotBlockEntity> {
    public static final ResourceLocation DECORATED_POT_SHEET = ResourceLocation.withDefaultNamespace((String)"textures/atlas/decorated_pot.png");
    private static final Material DECORATED_POT = new Material(DECORATED_POT_SHEET, LootrAPI.rl("entity/loot_pot"));
    private static final Material DECORATED_POT_OPENED = new Material(DECORATED_POT_SHEET, LootrAPI.rl("entity/loot_pot_open"));
    public static final ModelLayerLocation OPEN_POT_LAYER = new ModelLayerLocation(LootrProperties.DECORATED_POT, "main");
    private final ModelPart neck;
    private final ModelPart frontSide;
    private final ModelPart backSide;
    private final ModelPart leftSide;
    private final ModelPart rightSide;
    private final ModelPart top;
    private final ModelPart bottom;
    private final ModelPart open;
    private final ModelPart sherds;
    private static final Map<ResourceLocation, Material> cachedMaterials = new HashMap<ResourceLocation, Material>();

    public LootrDecoratedPotRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.bakeLayer(ModelLayers.DECORATED_POT_BASE);
        this.neck = modelPart.getChild("neck");
        this.top = modelPart.getChild("top");
        this.bottom = modelPart.getChild("bottom");
        ModelPart modelPart2 = context.bakeLayer(ModelLayers.DECORATED_POT_SIDES);
        this.frontSide = modelPart2.getChild("front");
        this.backSide = modelPart2.getChild("back");
        this.leftSide = modelPart2.getChild("left");
        this.rightSide = modelPart2.getChild("right");
        ModelPart modelPart3 = context.bakeLayer(OPEN_POT_LAYER);
        this.open = modelPart3.getChild("open");
        this.sherds = modelPart3.getChild("sherds");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition sherds = partdefinition.addOrReplaceChild("sherds", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        sherds.addOrReplaceChild("angled_sherd1_r1", CubeListBuilder.create().texOffs(17, 21).addBox(-0.5f, -0.5f, -4.5f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-3.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.829f));
        sherds.addOrReplaceChild("sherd2_r1", CubeListBuilder.create().texOffs(14, 19).addBox(-4.5f, -0.5f, -4.5f, 9.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.5f, (float)0.5f, (float)0.0f, (float)0.1309f, (float)0.0f));
        sherds.addOrReplaceChild("sherd1_r1", CubeListBuilder.create().texOffs(4, 16).addBox(-4.5f, -0.5f, -3.5f, 10.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        partdefinition.addOrReplaceChild("open", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -0.5f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 5).addBox(-2.8257f, 2.4924f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.75f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)-0.0873f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static Material getSideMaterial(ItemStack item) {
        if (!item.isEmpty()) {
            ResourceLocation customSide = SherdsIntegration.getCustomSideTexture(item);
            if (customSide != null) {
                return cachedMaterials.computeIfAbsent(customSide, rl -> new Material(DECORATED_POT_SHEET, rl.withPrefix("entity/decorated_pot/")));
            }
            Material material = Sheets.getDecoratedPotMaterial((ResourceKey)DecoratedPotPatterns.getPatternFromItem((Item)item.getItem()));
            if (material != null) {
                return material;
            }
        }
        return Sheets.DECORATED_POT_SIDE;
    }

    public void render(LootrDecoratedPotBlockEntity decoratedPotBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        Player player = ClientHooks.getPlayer();
        if (player == null) {
            return;
        }
        boolean opened = decoratedPotBlockEntity.hasClientOpened(player.getUUID());
        poseStack.pushPose();
        Direction direction = decoratedPotBlockEntity.getDirection();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - direction.toYRot()));
        if (!opened) {
            float g;
            poseStack.translate(-0.5, 0.0, -0.5);
            DecoratedPotBlockEntity.WobbleStyle wobbleStyle = decoratedPotBlockEntity.lastWobbleStyle;
            if (wobbleStyle != null && decoratedPotBlockEntity.getLevel() != null && (g = ((float)(decoratedPotBlockEntity.getLevel().getGameTime() - decoratedPotBlockEntity.wobbleStartedAtTick) + f) / (float)wobbleStyle.duration) >= 0.0f && g <= 1.0f) {
                if (wobbleStyle == DecoratedPotBlockEntity.WobbleStyle.POSITIVE) {
                    h = 0.015625f;
                    float k = g * ((float)Math.PI * 2);
                    float l = -1.5f * (Mth.cos((float)k) + 0.5f) * Mth.sin((float)(k / 2.0f));
                    poseStack.rotateAround(Axis.XP.rotation(l * 0.015625f), 0.5f, 0.0f, 0.5f);
                    float m = Mth.sin((float)k);
                    poseStack.rotateAround(Axis.ZP.rotation(m * 0.015625f), 0.5f, 0.0f, 0.5f);
                } else {
                    h = Mth.sin((float)(-g * 3.0f * (float)Math.PI)) * 0.125f;
                    float k = 1.0f - g;
                    poseStack.rotateAround(Axis.YP.rotation(h * k), 0.5f, 0.0f, 0.5f);
                }
            }
            VertexConsumer vertexConsumer = DECORATED_POT.buffer(multiBufferSource, RenderType::entitySolid);
            this.neck.render(poseStack, vertexConsumer, i, j);
            this.top.render(poseStack, vertexConsumer, i, j);
            this.bottom.render(poseStack, vertexConsumer, i, j);
            PotDecorationsAdapter potDecorations = decoratedPotBlockEntity.getDecorations();
            this.renderSide(this.frontSide, poseStack, multiBufferSource, i, j, LootrDecoratedPotRenderer.getSideMaterial(potDecorations.front()));
            this.renderSide(this.backSide, poseStack, multiBufferSource, i, j, LootrDecoratedPotRenderer.getSideMaterial(potDecorations.back()));
            this.renderSide(this.leftSide, poseStack, multiBufferSource, i, j, LootrDecoratedPotRenderer.getSideMaterial(potDecorations.left()));
            this.renderSide(this.rightSide, poseStack, multiBufferSource, i, j, LootrDecoratedPotRenderer.getSideMaterial(potDecorations.right()));
        } else {
            poseStack.scale(1.0f, -1.0f, -1.0f);
            VertexConsumer vertexConsumer = DECORATED_POT_OPENED.buffer(multiBufferSource, RenderType::entitySolid);
            this.open.render(poseStack, vertexConsumer, i, j);
            this.sherds.render(poseStack, vertexConsumer, i, j);
        }
        poseStack.popPose();
    }

    private void renderSide(ModelPart modelPart, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, Material material) {
        modelPart.render(poseStack, material.buffer(multiBufferSource, RenderType::entitySolid), i, j);
    }
}

