/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import org.jetbrains.annotations.Nullable;

public final class BlockEntityTicker {
    private static final Map<ResourceKey<Level>, BlockEntityTicker> TICKERS = new Object2ObjectOpenHashMap();
    private final ResourceKey<Level> levelKey;
    private final Map<ChunkPos, Entry> blockEntityEntries = new Object2ObjectOpenHashMap();
    private final Map<ChunkPos, Entry> pendingEntries = new Object2ObjectOpenHashMap();

    private BlockEntityTicker(ResourceKey<Level> levelKey) {
        this.levelKey = levelKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntity(BlockEntity entity, Level level, ChunkPos chunkPos) {
        BlockEntityTicker ticker;
        if (LootrAPI.isDisabled()) {
            return;
        }
        ResourceKey<Level> dimension = BlockEntityTicker.getServerDimensionIfValid(level);
        if (dimension == null) {
            return;
        }
        Map<ResourceKey<Level>, BlockEntityTicker> map = TICKERS;
        synchronized (map) {
            ticker = TICKERS.computeIfAbsent(dimension, BlockEntityTicker::new);
        }
        ticker.addEntity(level, entity, chunkPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntity(Level level, BlockEntity entity, ChunkPos chunkPos) {
        if (!LootrAPI.isWorldBorderSafe(level, chunkPos)) {
            return;
        }
        if (!BlockEntityTicker.isValidEntity(entity)) {
            return;
        }
        Map<ChunkPos, Entry> map = this.pendingEntries;
        synchronized (map) {
            Entry previousEntry = this.pendingEntries.get(chunkPos);
            if (previousEntry != null) {
                previousEntry.entityPositions.add(entity.getBlockPos());
            } else {
                HashSet<BlockPos> entityPositions = new HashSet<BlockPos>();
                entityPositions.add(entity.getBlockPos());
                Entry entry = new Entry(chunkPos, entityPositions);
                this.pendingEntries.put(chunkPos, entry);
            }
        }
    }

    private static boolean isValidEntity(BlockEntity entity) {
        if (LootrTags.BlockEntity.isTagged(entity, LootrTags.BlockEntity.CONVERT_BLACKLIST)) {
            return false;
        }
        if (entity instanceof ILootrBlockEntity || LootrAPI.resolveBlockEntity(entity) instanceof ILootrBlockEntity) {
            return false;
        }
        ILootrDataAdapter<BlockEntity> adapter = LootrAPI.getAdapter(entity);
        return adapter != null;
    }

    public static boolean isValidEntityFull(BlockEntity entity) {
        Set<ChunkPos> loadedChunks;
        if (LootrAPI.isDisabled()) {
            return false;
        }
        if (LootrTags.BlockEntity.isTagged(entity, LootrTags.BlockEntity.CONVERT_BLACKLIST)) {
            return false;
        }
        Level level = entity.getLevel();
        BlockPos pos = entity.getBlockPos();
        if (level == null) {
            return false;
        }
        if (level.isClientSide() || level.getServer() == null || LootrAPI.getServer() == null || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (entity instanceof ILootrBlockEntity || LootrAPI.resolveBlockEntity(entity) instanceof ILootrBlockEntity) {
            return false;
        }
        MinecraftServer server = level.getServer();
        if (!server.isSameThread()) {
            LootrAPI.LOG.error("Called isValidEntityFull on a non-server thread for {} in {}", (Object)entity, (Object)level.dimension());
            return false;
        }
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)serverLevel.dimension())) {
            return false;
        }
        if (!LootrAPI.isWorldBorderSafe(level, pos)) {
            return false;
        }
        if (LootrAPI.replacementBlockState(entity.getBlockState()) == null) {
            return false;
        }
        ILootrDataAdapter<BlockEntity> adapter = LootrAPI.getAdapter(entity);
        if (adapter == null) {
            return false;
        }
        ResourceKey<LootTable> lootTable = adapter.getLootTable(entity);
        if (lootTable == null) {
            return false;
        }
        if (LootrAPI.isLootTableBlacklisted(lootTable)) {
            return false;
        }
        Entry testEntry = new Entry(new ChunkPos(pos), Set.of(pos));
        return testEntry.getChunkLoadStatus(serverLevel, loadedChunks = LoadedChunks.getLoadedChunks((ResourceKey<Level>)level.dimension())) == ChunkLoadStatus.COMPLETE;
    }

    public static void onServerTick(MinecraftServer server) {
        if (LootrAPI.isDisabled()) {
            return;
        }
        for (BlockEntityTicker ticker : TICKERS.values()) {
            ServerLevel level = server.getLevel(ticker.levelKey);
            if (level == null) continue;
            ticker.onServerLevelTick(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerLevelTick(ServerLevel level) {
        Set<ChunkPos> loadedChunks = LoadedChunks.getLoadedChunks((ResourceKey<Level>)level.dimension());
        Iterator<Entry> iterator = this.blockEntityEntries.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            switch (entry.getChunkLoadStatus(level, loadedChunks).ordinal()) {
                case 0: {
                    iterator.remove();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    BlockEntityTicker.replaceEntitiesInChunk(level, entry);
                    iterator.remove();
                }
            }
        }
        Map<ChunkPos, Entry> map = this.pendingEntries;
        synchronized (map) {
            for (Entry entry : this.pendingEntries.values()) {
                this.blockEntityEntries.merge(entry.chunkPos, entry, (entry1, entry2) -> {
                    entry1.entityPositions.addAll(entry2.entityPositions);
                    return entry1;
                });
            }
            this.pendingEntries.clear();
        }
    }

    private static boolean checkStructureValidity(ServerLevel level, ChunkPos chunkPos, BlockPos position) {
        if (!level.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return true;
        }
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        if (registry.getTag(LootrTags.Structure.STRUCTURE_BLACKLIST).filter(tag -> tag.size() != 0).isPresent()) {
            return !LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_BLACKLIST, position);
        }
        if (registry.getTag(LootrTags.Structure.STRUCTURE_WHITELIST).filter(tag -> tag.size() != 0).isPresent()) {
            return LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_WHITELIST, position);
        }
        return true;
    }

    private static void replaceEntitiesInChunk(ServerLevel level, Entry entry) {
        for (BlockPos entityPos : entry.entityPositions()) {
            BlockState stateAt;
            BlockState replacement;
            ILootrDataAdapter<BlockEntity> adapter;
            BlockEntity blockEntity;
            if (!BlockEntityTicker.checkStructureValidity(level, entry.chunkPos(), entityPos) || LootrAPI.resolveBlockEntity(blockEntity = level.getBlockEntity(entityPos)) instanceof ILootrBlockEntity || (adapter = LootrAPI.getAdapter(blockEntity)) == null) continue;
            ResourceKey<LootTable> table = adapter.getLootTable(blockEntity);
            long seed = adapter.getLootSeed(blockEntity);
            if (table == null) {
                if (!LootrAPI.shouldWarnNoLootTables()) continue;
                LootrAPI.LOG.warn("Potential block entity {} has no loot table in {} ({})", (Object)blockEntity, (Object)level.dimension(), (Object)entityPos);
                continue;
            }
            if (LootrAPI.isLootTableBlacklisted(table) || (replacement = LootrAPI.replacementBlockState(stateAt = level.getBlockState(entityPos))) == null) continue;
            BlockEntityTicker.replaceEntity(level, entityPos, adapter, blockEntity, replacement, table, seed);
        }
    }

    private static void replaceEntity(ServerLevel level, BlockPos entityPos, ILootrDataAdapter<BlockEntity> adapter, BlockEntity be, BlockState replacement, ResourceKey<LootTable> table, long seed) {
        LootrAPI.preProcess(level, entityPos, be, replacement, table, seed);
        DataToCopy data = PlatformAPI.copySpecificData(be);
        ItemStack itemCopy = ItemStack.EMPTY;
        if (adapter.hasCopyableComponentsViaItem(be)) {
            itemCopy = new ItemStack((ItemLike)be.getBlockState().getBlock());
            be.saveToItem(itemCopy, (HolderLookup.Provider)level.registryAccess());
        }
        adapter.setLootTable(be, null, 0L);
        level.setBlock(entityPos, replacement, 2);
        BlockEntity newBlockEntity = level.getBlockEntity(entityPos);
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(newBlockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity) {
            ILootrBlockEntity ibe = iLootrBlockEntity;
            if (!itemCopy.isEmpty()) {
                ibe.asBlockEntity().applyComponentsFromItemStack(itemCopy);
            }
            PlatformAPI.restoreSpecificData(data, newBlockEntity);
            ibe.setLootTableInternal(table, seed);
            ibe.performUpdate();
            LootrAPI.postProcess(level, entityPos, ibe.asBlockEntity(), replacement, table, seed);
        } else {
            LootrAPI.LOG.error("Somehow, replacement result {} is not an ILootrBlockEntity {} at {}", (Object)replacement, (Object)level.dimension(), (Object)entityPos);
        }
    }

    @Nullable
    private static ResourceKey<Level> getServerDimensionIfValid(Level level) {
        if (LootrAPI.getServer() == null || level.isClientSide()) {
            return null;
        }
        ResourceKey dimension = level.dimension();
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)dimension)) {
            return null;
        }
        return dimension;
    }

    public record Entry(ChunkPos chunkPos, Set<BlockPos> entityPositions) {
        public ChunkLoadStatus getChunkLoadStatus(ServerLevel level, Set<ChunkPos> loadedChunks) {
            ServerChunkCache chunkSource = level.getChunkSource();
            if (!LootrAPI.isWorldBorderSafe((Level)level, this.chunkPos) || !chunkSource.hasChunk(this.chunkPos.x, this.chunkPos.z)) {
                return ChunkLoadStatus.UNLOADED;
            }
            if (!loadedChunks.contains(this.chunkPos)) {
                return ChunkLoadStatus.NOT_FULLY_LOADED;
            }
            for (int x = this.chunkPos.x - 2; x <= this.chunkPos.x + 2; ++x) {
                for (int z = this.chunkPos.z - 2; z <= this.chunkPos.z + 2; ++z) {
                    ChunkPos pos;
                    if (x == this.chunkPos.x && z == this.chunkPos.z || !LootrAPI.isWorldBorderSafe((Level)level, pos = new ChunkPos(x, z)) || loadedChunks.contains(pos)) continue;
                    return ChunkLoadStatus.SURROUNDING_CHUNKS_NOT_LOADED;
                }
            }
            return ChunkLoadStatus.COMPLETE;
        }
    }

    public static enum ChunkLoadStatus {
        UNLOADED,
        SURROUNDING_CHUNKS_NOT_LOADED,
        NOT_FULLY_LOADED,
        COMPLETE;

    }
}

