package net.zestyblaze.lootr.advancement;

import com.google.gson.JsonObject;
import net.minecraft.server.level.ServerPlayer;
import net.zestyblaze.lootr.api.advancement.IGenericPredicate;
import net.zestyblaze.lootr.init.ModStats;
import org.jetbrains.annotations.Nullable;

public class LootedStatPredicate implements IGenericPredicate<Void> {
  private int score = -1;

  public LootedStatPredicate() {
  }

  public LootedStatPredicate(int score) {
    this.score = score;
  }

  @Override
  public boolean test(ServerPlayer player, Void condition) {
    return player.getStats().getValue(ModStats.LOOTED_STAT) >= score;
  }

  @Override
  public IGenericPredicate<Void> deserialize(@Nullable JsonObject element) {
    if (element == null) {
      throw new IllegalArgumentException("Element cannot be null");
    }

    int score = element.getAsJsonPrimitive("score").getAsInt();
    return new LootedStatPredicate(score);
  }
}
