/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.splashy.mixin;

import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import net.darkhax.splashy.Constants;
import net.darkhax.splashy.gui.components.EmptySplashRenderer;
import net.darkhax.splashy.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SplashManager.class})
public class MixinSplashManager {
    @Unique
    private static final SplashRenderer JARED_BIRTHDAY = new SplashRenderer("Happy Birthday Jared <3");
    @Final
    @Shadow
    private List<String> splashes;

    @Inject(method={"apply(Ljava/util/List;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void apply(List<String> vanillaValues, ResourceManager resources, ProfilerFiller profiler, CallbackInfo ci) {
        if (Constants.CONFIG.displaySplashes) {
            if (!Constants.CONFIG.includeVanillaSplashes) {
                this.splashes.removeAll(vanillaValues);
            }
            if (Constants.CONFIG.includeModNames) {
                this.splashes.addAll(Services.HELPER.getLoadedMods().stream().filter(s -> !s.contains("Fabric") && !s.contains("API")).toList());
            }
            String username = Minecraft.getInstance().getUser().getName();
            String version = Minecraft.getInstance().getLaunchedVersion();
            for (String customSplash : Constants.CONFIG.customSplashes) {
                if (I18n.exists((String)customSplash)) {
                    customSplash = I18n.get((String)customSplash, (Object[])new Object[]{username, version});
                }
                this.splashes.add(customSplash);
            }
        }
    }

    @Inject(method={"getSplash()Lnet/minecraft/client/gui/components/SplashRenderer;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getSplash(CallbackInfoReturnable<SplashRenderer> cir) {
        if (Constants.CONFIG.displaySplashes) {
            LocalDateTime now = LocalDateTime.now();
            if (now.getMonth() == Month.JUNE && now.getDayOfMonth() == 29) {
                cir.setReturnValue((Object)JARED_BIRTHDAY);
            }
        } else {
            cir.setReturnValue((Object)EmptySplashRenderer.EMPTY);
        }
    }
}

