/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.simplelootviewer.common.impl.data;

import com.google.common.collect.ArrayListMultimap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.darkhax.simplelootviewer.common.impl.data.LootTableHelper;
import net.darkhax.simplelootviewer.common.impl.data.LootType;
import net.darkhax.simplelootviewer.common.impl.data.info.TableInfo;
import net.darkhax.simplelootviewer.common.lib.DataRecipe;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class LootDataProviderRecipe
extends DataRecipe {
    public static final ResourceLocation TYPE_ID = SimpleLootViewer.id("loot_table_info");
    public static final Supplier<RecipeType<LootDataProviderRecipe>> TYPE = CachedSupplier.of((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)TYPE_ID).cast();
    public static final MapCodec<LootDataProviderRecipe> CODEC = MapCodec.unit(() -> new LootDataProviderRecipe(LootTableHelper.getCachedData(Objects.requireNonNull((RegistryAccess)SimpleLootViewer.REGISTRY_ACCESS.get()))));
    public static final StreamCodec<RegistryFriendlyByteBuf, LootDataProviderRecipe> STREAM = StreamCodec.of((buf, val) -> {
        buf.writeVarInt(val.data.keySet().size());
        val.data.keySet().forEach(type -> {
            buf.writeEnum((Enum)type);
            TableInfo.LIST_STREAM.encode(buf, (Object)val.data.get((Object)type));
        });
    }, buf -> {
        ArrayListMultimap data = ArrayListMultimap.create();
        int size = buf.readVarInt();
        for (int i = 0; i < size; ++i) {
            LootType type = (LootType)buf.readEnum(LootType.class);
            List info = (List)TableInfo.LIST_STREAM.decode(buf);
            data.putAll((Object)type, (Iterable)info);
        }
        return new LootDataProviderRecipe((ArrayListMultimap<LootType, TableInfo>)data);
    });
    public static final RecipeSerializer<LootDataProviderRecipe> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    private final ArrayListMultimap<LootType, TableInfo> data;

    public LootDataProviderRecipe(ArrayListMultimap<LootType, TableInfo> data) {
        this.data = data;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE.get();
    }

    public ArrayListMultimap<LootType, TableInfo> getData() {
        return this.data;
    }
}

