package net.darkhax.simplelootviewer.common.impl.data.info;

import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.List;

/**
 * Represents a loot table and the data associated with it.
 *
 * @param lootTable The ID of the loot table.
 * @param name      The name of the loot table.
 * @param items     A list of items that can be dropped by the loot table.
 */
public record TableInfo(class_2960 lootTable, Name name, List<class_1799> items) {

    public static class_9139<class_9129, TableInfo> STREAM = class_9139.method_56437(
            (buf, val) -> {
                buf.method_10812(val.lootTable);
                Name.STREAM.encode(buf, val.name);
                SimpleLootViewer.ITEM_STACK_LIST.encode(buf, val.items);
            },
            buf -> {
                final class_2960 tableKey = buf.method_10810();
                final Name name = Name.STREAM.decode(buf);
                final List<class_1799> items = SimpleLootViewer.ITEM_STACK_LIST.decode(buf);
                return new TableInfo(tableKey, name, items);
            }
    );
    public static class_9139<class_9129, List<TableInfo>> LIST_STREAM = StreamCodecs.list(STREAM);
}