package net.darkhax.simplelootviewer.common.impl.data.info;

import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.darkhax.simplelootviewer.common.impl.data.LootTableHelper;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Different types of names that we can serialize.
 */
public enum NameType {

    /**
     * Handles block names. Only the ID of each block is serialized, the client will look up these IDs and join each
     * unique name together.
     */
    BLOCK(SimpleLootViewer.UNSAFE_ID_ARRAY_STREAM, data -> TextHelper.joinUnique(SimpleLootViewer.SEPARATOR, Arrays.stream((class_2960[]) data).map(id -> class_7923.field_41175.method_10223(id).method_9518()).collect(Collectors.toList()))),

    /**
     * Handles entity names. Only the ID of each entity is serialized, the client will look up these IDs and join eac
     * unique name together.
     */
    ENTITY(SimpleLootViewer.UNSAFE_ID_ARRAY_STREAM, data -> TextHelper.joinUnique(SimpleLootViewer.SEPARATOR, Arrays.stream((class_2960[]) data).map(id -> class_7923.field_41177.method_10223(id).method_5897()).collect(Collectors.toList()))),

    /**
     * Handles loot tables with names derived from their resource location.
     */
    TABLE(SimpleLootViewer.UNSAFE_ID_STREAM, data -> LootTableHelper.nameTableFromId((class_2960) data)),

    /**
     * Handles names that are sent as only a localization key.
     */
    KEY(class_9139.method_56437((buf, val) -> buf.method_10814((String) val), class_2540::method_19772), data -> class_2561.method_43471((String) data)),

    /**
     * Handles full components without any size mitigating strategy. This is unused but may be used by addons or used in
     * the future.
     */
    COMPONENT(class_9139.method_56437((buf, val) -> class_8824.field_48540.encode(buf, (class_2561) val), class_8824.field_48540::decode), data -> (class_2561) data);

    /**
     * Handles serializing the data across the network.
     */
    public final class_9139<class_9129, Object> dataCodec;

    /**
     * Handles converting the data into a name.
     */
    public final Function<Object, class_2561> nameBuilder;

    NameType(class_9139<class_9129, Object> dataCodec, Function<Object, class_2561> nameBuilder) {
        this.dataCodec = dataCodec;
        this.nameBuilder = nameBuilder;
    }
}