package net.darkhax.simplelootviewer.common.impl.data;

import com.google.common.collect.ArrayListMultimap;
import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.darkhax.simplelootviewer.common.impl.data.info.TableInfo;
import net.darkhax.simplelootviewer.common.lib.DataRecipe;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

/**
 * A built-in recipe type to handle syncing all the data to clients. While this can be done in other ways, using a
 * recipe ensures the data is reloadable, synced to the client, and made available before has loaded plugins.
 */
public class LootDataProviderRecipe extends DataRecipe {

    public static final class_2960 TYPE_ID = SimpleLootViewer.id("loot_table_info");
    public static final Supplier<class_3956<LootDataProviderRecipe>> TYPE = CachedSupplier.of(class_7923.field_41188, TYPE_ID).cast();
    public static final MapCodec<LootDataProviderRecipe> CODEC = MapCodec.unit(() -> new LootDataProviderRecipe(LootTableHelper.getCachedData(Objects.requireNonNull(SimpleLootViewer.REGISTRY_ACCESS.get()))));

    public static final class_9139<class_9129, LootDataProviderRecipe> STREAM = class_9139.method_56437(
            (buf, val) -> {
                buf.method_10804(val.data.keySet().size());
                val.data.keySet().forEach(type -> {
                    buf.method_10817(type);
                    TableInfo.LIST_STREAM.encode(buf, val.data.get(type));
                });
            },
            buf -> {
                final ArrayListMultimap<LootType, TableInfo> data = ArrayListMultimap.create();
                final int size = buf.method_10816();
                for (int i = 0; i < size; i++) {
                    final LootType type = buf.method_10818(LootType.class);
                    List<TableInfo> info = TableInfo.LIST_STREAM.decode(buf);
                    data.putAll(type, info);
                }
                return new LootDataProviderRecipe(data);
            }
    );
    public static final class_1865<LootDataProviderRecipe> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);

    private final ArrayListMultimap<LootType, TableInfo> data;

    public LootDataProviderRecipe(ArrayListMultimap<LootType, TableInfo> data) {
        this.data = data;
    }

    @NotNull
    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @NotNull
    @Override
    public class_3956<?> method_17716() {
        return TYPE.get();
    }

    public ArrayListMultimap<LootType, TableInfo> getData() {
        return this.data;
    }
}
