package net.darkhax.simplelootviewer.common.impl.jei;

import com.google.common.collect.ArrayListMultimap;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.darkhax.simplelootviewer.common.impl.data.LootDataProviderRecipe;
import net.darkhax.simplelootviewer.common.impl.data.LootType;
import net.darkhax.simplelootviewer.common.impl.data.info.TableInfo;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

@JeiPlugin
public class Plugin implements IModPlugin {

    public static final class_2960 PLUGIN_ID = SimpleLootViewer.id("jei_plugin");

    private final Map<LootType, RecipeType<TableInfo>> info = new HashMap<>();

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        final IGuiHelper gui = registration.getJeiHelpers().getGuiHelper();
        for (LootType type : LootType.values()) {
            final RecipeType<TableInfo> recipeType = RecipeType.create(type.id.method_12836(), type.id.method_12832(), TableInfo.class);
            registration.addRecipeCategories(new LootCategory(recipeType, type, gui));
            info.put(type, recipeType);
        }
    }

    @Override
    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (class_310.method_1551().field_1687 != null) {
            for (class_8786<LootDataProviderRecipe> data : class_310.method_1551().field_1687.method_8433().method_30027(LootDataProviderRecipe.TYPE.get())) {
                final ArrayListMultimap<LootType, TableInfo> entries = data.comp_1933().getData();
                for (LootType type : entries.keySet()) {
                    registration.addRecipes(info.get(type), entries.get(type));
                    SimpleLootViewer.LOG.info("Registering {} {} entries.", entries.get(type).size(), type);
                }
            }
        }
    }

    @NotNull
    @Override
    public class_2960 getPluginUid() {
        return PLUGIN_ID;
    }
}
