package net.darkhax.simplelootviewer.common.impl.data;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.darkhax.simplelootviewer.common.impl.config.CategoryConfig;
import net.darkhax.simplelootviewer.common.impl.config.Config;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

/**
 * The different categories of loot tables handled by this mod.
 */
public enum LootType {

    BLOCK(path -> path.startsWith("blocks/"), () -> class_1802.field_8335, cfg -> cfg.block_drops),
    ENTITY(path -> path.startsWith("entities/"), () -> class_1802.field_8503, cfg -> cfg.mob_drops),
    LOOT_CHEST(path -> path.startsWith("chests/"), () -> class_1802.field_8106, cfg -> cfg.loot_chests),
    FISHING(path -> path.startsWith("gameplay/fishing"), () -> class_1802.field_8378, cfg -> cfg.fishing),
    HERO(path -> path.startsWith("gameplay/hero"), () -> class_1802.field_8086, cfg -> cfg.village_hero),
    ARCHAEOLOGY(path -> path.startsWith("archaeology/"), () -> class_1802.field_42716, cfg -> cfg.archaeology),
    DISPENSER(path -> path.startsWith("dispensers/"), () -> class_1802.field_8357, cfg -> cfg.dispensers),
    MISC(path -> true, () -> class_1802.field_27023, cfg -> cfg.misc);

    public final class_2960 id;
    public final Predicate<String> matcher;
    public final CachedSupplier<class_1935> icon;
    public final Function<Config, CategoryConfig> configGetter;

    LootType(Predicate<String> matcher, Supplier<class_1935> icon, Function<Config, CategoryConfig> configGetter) {
        this.id = SimpleLootViewer.id(this.name().toLowerCase(Locale.ROOT));
        this.icon = CachedSupplier.cache(icon);
        this.matcher = matcher;
        this.configGetter = configGetter;
    }

    public boolean isEnabled() {
        return this.configGetter.apply(SimpleLootViewer.CONFIG.get()).enabled;
    }

    public static LootType determineType(class_2960 tableId) {
        final LootType override = SimpleLootViewer.CONFIG.get().type_overrides.get().get(tableId);
        if (override != null) {
            return override;
        }
        final String path = tableId.method_12832();
        for (LootType type : LootType.values()) {
            if (type.matcher.test(path)) {
                return type;
            }
        }
        return MISC;
    }
}